Attribute VB_Name = "textprep"
Sub kPrepressAll()
Application.ScreenUpdating = False
    Application.Run MacroName:="CleanupTextMain"
    Application.Run MacroName:="AddCharacterTagMain"
    Application.Run MacroName:="SaveAsTxt"
End Sub
Sub kPrepress()
Application.ScreenUpdating = False
    Application.Run MacroName:="CleanupTextMain"
    Application.Run MacroName:="AddCharacterTagMain"
    Application.Run MacroName:="SaveEdited"
End Sub
Sub kPrepressStay()
Application.ScreenUpdating = False
    Application.Run MacroName:="CleanupTextMain"
    Application.Run MacroName:="AddCharacterTagMain"
    Application.Run MacroName:="SaveAsTxtStay"
End Sub
Sub DoFindReplaceMain(FindText As String, ReplaceText As String, _
  Optional bMatchWildcards As Boolean = False, Optional bMatchCase As Boolean = False)
ActiveDocument.StoryRanges(wdMainTextStory).Select
With Selection.Find
    .ClearFormatting
    .Replacement.ClearFormatting
    .Text = FindText
    .Replacement.Text = ReplaceText
    .Forward = True
    .Wrap = wdFindContinue
    .Format = False
    .MatchCase = bMatchCase
    .MatchWholeWord = False
    .MatchWildcards = bMatchWildcards
    .MatchSoundsLike = False
    .MatchAllWordForms = False
    Do While .Execute
        'Keep going until nothing found
        .Execute Replace:=wdReplaceAll
    Loop
    'Free up some memory
    ActiveDocument.UndoClear
End With
End Sub
Sub DoFindReplaceNote(FindText As String, ReplaceText As String, _
  Optional bMatchWildcards As Boolean = False, Optional bMatchCase As Boolean = False)
If ActiveDocument.Footnotes.Count > 0 Then
ActiveDocument.StoryRanges(wdFootnotesStory).Select
With Selection.Find
    .ClearFormatting
    .Replacement.ClearFormatting
    .Text = FindText
    .Replacement.Text = ReplaceText
    .Forward = True
    .Wrap = wdFindContinue
    .Format = False
    .MatchCase = bMatchCase
    .MatchWholeWord = False
    .MatchWildcards = bMatchWildcards
    .MatchSoundsLike = False
    .MatchAllWordForms = False
    Do While .Execute
        'Keep going until nothing found
        .Execute Replace:=wdReplaceAll
    Loop
    'Free up some memory
    ActiveDocument.UndoClear
End With
On Error Resume Next
End If
If ActiveDocument.Endnotes.Count > 0 Then
ActiveDocument.StoryRanges(wdEndnotesStory).Select
With Selection.Find
    .ClearFormatting
    .Replacement.ClearFormatting
    .Text = FindText
    .Replacement.Text = ReplaceText
    .Forward = True
    .Wrap = wdFindContinue
    .Format = False
    .MatchCase = bMatchCase
    .MatchWholeWord = False
    .MatchWildcards = bMatchWildcards
    .MatchSoundsLike = False
    .MatchAllWordForms = False
    Do While .Execute
        'Keep going until nothing found
        .Execute Replace:=wdReplaceAll
    Loop
    'Free up some memory
    ActiveDocument.UndoClear
End With
On Error Resume Next
End If
End Sub
Sub CleanupTextMain()
' Удаление пробелов и табуляций лидирующих в абзацах
    Call DoFindReplaceMain("^p^w", "^p")
' Удаление пробелов и табуляций завершающих абзацы
    Call DoFindReplaceMain("^w^p", "^p")
' Замена множественных пробелов одним
    Call DoFindReplaceMain("^0032{2;}", "^0032", True)
' Удаление пробела перед знаком препинания
    Call DoFindReplaceMain(" ([.,:;\!\?])", "\1", True)
' Вставка пробела между знаком препинания и буквой
    Call DoFindReplaceMain("([,:;\!\?])([A-Za-zА-яЁё])", "\1 \2", True)
' Замена пробела между цифрой и буквой на неразрывный пробел
    Call DoFindReplaceMain("([0-9]) ([A-Za-zА-яЁё])", "\1^s\2", True)
' Замена пробела между цифрой и знаком % на неразрывный пробел
    Call DoFindReplaceMain("([0-9]) (%)", "\1^s\2", True)
' Замена пробела после знака номера на неразрывный пробел
    Call DoFindReplaceMain("(№) ", "\1^s", True)
' Замена пробела после знака параграфа на неразрывный пробел
    Call DoFindReplaceMain("(§) ", "\1^s", True)
' Замена пробела между цифрой и °C на неразрывный пробел
    Call DoFindReplaceMain("([0-9]) (°C>)", "\1^s\2", True)
' Удаление пробела после открывающей круглой скобки
    Call DoFindReplaceMain("([\(]) ", "\1", True)
' Удаление пробела перед закрывающей круглой скобкой
    Call DoFindReplaceMain(" ([\)])", "\1", True)
' Вставка пробела между буквой и открывающей круглой скобкой
    Call DoFindReplaceMain("([A-Za-zА-яЁё])([\(])", "\1 \2", True)
' Вставка пробела между закрывающей круглой скобкой и буквой
    Call DoFindReplaceMain("([\)])([A-Za-zА-яЁё])", "\1 \2", True)
' Удаление пробела после открывающей квадратной скобки
    Call DoFindReplaceMain("([\[]) ", "\1", True)
' Удаление пробела перед закрывающей квадратной скобкой
    Call DoFindReplaceMain(" ([\]])", "\1", True)
' Замена пробела перед знаком "/" на неразрывный пробел
    Call DoFindReplaceMain(" / ", "^s/ ")
' Замена пробела перед знаком "//" на неразрывный пробел
    Call DoFindReplaceMain(" // ", "^s// ")
' Замена пробела после сокращений P.; p.; С.; с.; Т.; т.; кн.; им.; ср.; см. на неразрывный пробел
    Call DoFindReplaceMain("(<[PpСсТт].) ", "\1^s", True)
    Call DoFindReplaceMain("(<кн.) ", "\1^s", True)
    Call DoFindReplaceMain("(<им.) ", "\1^s", True)
    Call DoFindReplaceMain("(<ср.) ", "\1^s", True)
    Call DoFindReplaceMain("(<см.) ", "\1^s", True)
' Замена пробелов в сокращениях т. к.; т. е.; и т. д.; и т. п.; и др.; и пр. на неразрывные пробелы
    Call DoFindReplaceMain("(<т.) (к.) ", "\1^s\2^s", True)
    Call DoFindReplaceMain("(<т.) (е.) ", "\1^s\2^s", True)
    Call DoFindReplaceMain("(<и) (т.) (д.)", "\1^s\2^s\3", True)
    Call DoFindReplaceMain("(<и) (т.) (п.)", "\1^s\2^s\3", True)
    Call DoFindReplaceMain("(<и) (др.)", "\1^s\2", True)
    Call DoFindReplaceMain("(<и) (пр.)", "\1^s\2", True)
' Замена двойного дефиса на тире
    Call DoFindReplaceMain("--", "^0150")
' Замена пробел-дефис-пробел на пробел-тире-пробел
    Call DoFindReplaceMain(" - ", "^s^0150 ")
' Замена M-тире на N-тире
    Call DoFindReplaceMain("^0151", "^0150")
' Замена пробела перед тире на неразрывный пробел
    Call DoFindReplaceMain(" ^0150 ", "^s^0150 ")
' Замена дефиса между цифрами на тире
    Call DoFindReplaceMain("([0-9])-([0-9])", "\1^0150\2", True)
' Замена дефиса между цифрой и буквой на неразрывный дефис
    Call DoFindReplaceMain("([0-9])-([A-Za-zА-яЁё])", "\1^~\2", True)
' Замена дефиса между буквой и цифрой на неразрывный дефис
    Call DoFindReplaceMain("([A-Za-zА-яЁё])-([0-9])", "\1^~\2", True)
' Удаление жестких переносов
    Call DoFindReplaceMain("-^p", "")
' Замена пробела после однобуквенного предлога, союза или частицы на неразрывный пробел
    Call DoFindReplaceMain("(<[АаИиВвКкОоСсУу]) ", "\1^s", True)
' Замена пробела перед однобуквенной частицей на неразрывный пробел
    Call DoFindReplaceMain(" ([бж]>)", "^s\1", True)
' Замена пробела после двухбуквенного предлога, союза или частицы на неразрывный пробел
    Call DoFindReplaceMain("(<аж) ", "\1^s", True)
    Call DoFindReplaceMain("(<ай) ", "\1^s", True)
    Call DoFindReplaceMain("(<ан) ", "\1^s", True)
    Call DoFindReplaceMain("(<во) ", "\1^s", True)
    Call DoFindReplaceMain("(<да) ", "\1^s", True)
    Call DoFindReplaceMain("(<до) ", "\1^s", True)
    Call DoFindReplaceMain("(<за) ", "\1^s", True)
    Call DoFindReplaceMain("(<из) ", "\1^s", True)
    Call DoFindReplaceMain("(<ко) ", "\1^s", True)
    Call DoFindReplaceMain("(<на) ", "\1^s", True)
    Call DoFindReplaceMain("(<не) ", "\1^s", True)
    Call DoFindReplaceMain("(<ни) ", "\1^s", True)
    Call DoFindReplaceMain("(<но) ", "\1^s", True)
    Call DoFindReplaceMain("(<ну) ", "\1^s", True)
    Call DoFindReplaceMain("(<об) ", "\1^s", True)
    Call DoFindReplaceMain("(<от) ", "\1^s", True)
    Call DoFindReplaceMain("(<по) ", "\1^s", True)
    Call DoFindReplaceMain("(<со) ", "\1^s", True)
    Call DoFindReplaceMain("(<то) ", "\1^s", True)
    Call DoFindReplaceMain("(<уж) ", "\1^s", True)
' Замена пробела перед двухбуквенной частицей на неразрывный пробел
    Call DoFindReplaceMain(" (бы>)", "^s\1", True)
    Call DoFindReplaceMain(" (же>)", "^s\1", True)
    Call DoFindReplaceMain(" (ли>)", "^s\1", True)
    Call DoFindReplaceMain(" (ль>)", "^s\1", True)
    Application.Run MacroName:="CleanupTextNote"
End Sub
Sub CleanupTextNote()
' Удаление пробелов и табуляций лидирующих в абзацах
    Call DoFindReplaceNote("^p^w", "^p")
' Удаление пробелов и табуляций завершающих абзацы
    Call DoFindReplaceNote("^w^p", "^p")
' Замена множественных пробелов одним
    Call DoFindReplaceNote("^0032{2;}", "^0032", True)
' Удаление пробела перед знаком препинания
    Call DoFindReplaceNote(" ([.,:;\!\?])", "\1", True)
' Вставка пробела между знаком препинания и буквой
    Call DoFindReplaceNote("([,:;\!\?])([A-Za-zА-яЁё])", "\1 \2", True)
' Замена пробела между цифрой и буквой на неразрывный пробел
    Call DoFindReplaceNote("([0-9]) ([A-Za-zА-яЁё])", "\1^s\2", True)
' Замена пробела между цифрой и знаком % на неразрывный пробел
    Call DoFindReplaceNote("([0-9]) (%)", "\1^s\2", True)
' Замена пробела после знака номера на неразрывный пробел
    Call DoFindReplaceNote("(№) ", "\1^s", True)
' Замена пробела после знака параграфа на неразрывный пробел
    Call DoFindReplaceNote("(§) ", "\1^s", True)
' Замена пробела между цифрой и °C на неразрывный пробел
    Call DoFindReplaceNote("([0-9]) (°C>)", "\1^s\2", True)
' Удаление пробела после открывающей круглой скобки
    Call DoFindReplaceNote("([\(]) ", "\1", True)
' Удаление пробела перед закрывающей круглой скобкой
    Call DoFindReplaceNote(" ([\)])", "\1", True)
' Вставка пробела между буквой и открывающей круглой скобкой
    Call DoFindReplaceNote("([A-Za-zА-яЁё])([\(])", "\1 \2", True)
' Вставка пробела между закрывающей круглой скобкой и буквой
    Call DoFindReplaceNote("([\)])([A-Za-zА-яЁё])", "\1 \2", True)
' Удаление пробела после открывающей квадратной скобки
    Call DoFindReplaceNote("([\[]) ", "\1", True)
' Удаление пробела перед закрывающей квадратной скобкой
    Call DoFindReplaceNote(" ([\]])", "\1", True)
' Замена пробела перед знаком "/" на неразрывный пробел
    Call DoFindReplaceNote(" / ", "^s/ ")
' Замена пробела перед знаком "//" на неразрывный пробел
    Call DoFindReplaceNote(" // ", "^s// ")
' Замена пробела после сокращений P.; p.; С.; с.; Т.; т.; кн.; им.; ср.; см. на неразрывный пробел
    Call DoFindReplaceNote("(<[PpСсТт].) ", "\1^s", True)
    Call DoFindReplaceNote("(<кн.) ", "\1^s", True)
    Call DoFindReplaceNote("(<им.) ", "\1^s", True)
    Call DoFindReplaceNote("(<ср.) ", "\1^s", True)
    Call DoFindReplaceNote("(<см.) ", "\1^s", True)
' Замена пробелов в сокращениях т. к.; т. е.; и т. д.; и т. п.; и др.; и пр. на неразрывные пробелы
    Call DoFindReplaceNote("(<т.) (к.) ", "\1^s\2^s", True)
    Call DoFindReplaceNote("(<т.) (е.) ", "\1^s\2^s", True)
    Call DoFindReplaceNote("(<и) (т.) (д.)", "\1^s\2^s\3", True)
    Call DoFindReplaceNote("(<и) (т.) (п.)", "\1^s\2^s\3", True)
    Call DoFindReplaceNote("(<и) (др.)", "\1^s\2", True)
    Call DoFindReplaceNote("(<и) (пр.)", "\1^s\2", True)
' Замена двойного дефиса на тире
    Call DoFindReplaceNote("--", "^0150")
' Замена пробел-дефис-пробел на пробел-тире-пробел
    Call DoFindReplaceNote(" - ", "^s^0150 ")
' Замена M-тире на N-тире
    Call DoFindReplaceNote("^0151", "^0150")
' Замена пробела перед тире на неразрывный пробел
    Call DoFindReplaceNote(" ^0150 ", "^s^0150 ")
' Замена дефиса между цифрами на тире
    Call DoFindReplaceNote("([0-9])-([0-9])", "\1^0150\2", True)
' Замена дефиса между цифрой и буквой на неразрывный дефис
    Call DoFindReplaceNote("([0-9])-([A-Za-zА-яЁё])", "\1^~\2", True)
' Замена дефиса между буквой и цифрой на неразрывный дефис
    Call DoFindReplaceNote("([A-Za-zА-яЁё])-([0-9])", "\1^~\2", True)
' Удаление жестких переносов
    Call DoFindReplaceNote("-^p", "")
' Замена пробела после однобуквенного предлога, союза или частицы на неразрывный пробел
    Call DoFindReplaceNote("(<[АаИиВвКкОоСсУу]) ", "\1^s", True)
' Замена пробела перед однобуквенной частицей на неразрывный пробел
    Call DoFindReplaceNote(" ([бж]>)", "^s\1", True)
' Замена пробела после двухбуквенного предлога, союза или частицы на неразрывный пробел
    Call DoFindReplaceNote("(<аж) ", "\1^s", True)
    Call DoFindReplaceNote("(<ай) ", "\1^s", True)
    Call DoFindReplaceNote("(<ан) ", "\1^s", True)
    Call DoFindReplaceNote("(<во) ", "\1^s", True)
    Call DoFindReplaceNote("(<да) ", "\1^s", True)
    Call DoFindReplaceNote("(<до) ", "\1^s", True)
    Call DoFindReplaceNote("(<за) ", "\1^s", True)
    Call DoFindReplaceNote("(<из) ", "\1^s", True)
    Call DoFindReplaceNote("(<ко) ", "\1^s", True)
    Call DoFindReplaceNote("(<на) ", "\1^s", True)
    Call DoFindReplaceNote("(<не) ", "\1^s", True)
    Call DoFindReplaceNote("(<ни) ", "\1^s", True)
    Call DoFindReplaceNote("(<но) ", "\1^s", True)
    Call DoFindReplaceNote("(<ну) ", "\1^s", True)
    Call DoFindReplaceNote("(<об) ", "\1^s", True)
    Call DoFindReplaceNote("(<от) ", "\1^s", True)
    Call DoFindReplaceNote("(<по) ", "\1^s", True)
    Call DoFindReplaceNote("(<со) ", "\1^s", True)
    Call DoFindReplaceNote("(<то) ", "\1^s", True)
    Call DoFindReplaceNote("(<уж) ", "\1^s", True)
' Замена пробела перед двухбуквенной частицей на неразрывный пробел
    Call DoFindReplaceNote(" (бы>)", "^s\1", True)
    Call DoFindReplaceNote(" (же>)", "^s\1", True)
    Call DoFindReplaceNote(" (ли>)", "^s\1", True)
    Call DoFindReplaceNote(" (ль>)", "^s\1", True)
' Замена пробела после фамилии перед инициалами в примечаниях на неразрывный пробел
    Call DoFindReplaceNote("([a-zа-яё]) ([A-ZА-Я].[A-ZА-Я].)", "\1^s\2", True)
    Call DoFindReplaceNote("([a-zа-яё]) ([A-ZА-Я].)", "\1^s\2", True)
End Sub
Sub AddCharacterTagMain()
Attribute AddCharacterTagMain.VB_Description = "Makro erstellt am 30.10.2005 von admin"
Attribute AddCharacterTagMain.VB_ProcData.VB_Invoke_Func = "Normal.NewMacros.DTXspch"
    Call DoFindReplaceMain("^s", "<\!s>")
    Call DoFindReplaceMain("^~", "<\!->")
    Call DoFindReplaceMain(ChrW(8213), "<\#150>")
    Call DoFindReplaceMain(ChrW(8220), "<\#147>")
    Call DoFindReplaceMain(ChrW(8221), "<\#148>")
    Call DoFindReplaceMain(ChrW(8222), "<\#132>")
    Call DoFindReplaceMain("‚", "<\#130>")
    Call DoFindReplaceMain("…", "<\#133>")
    Call DoFindReplaceMain("‘", "<\#145>")
    Call DoFindReplaceMain("’", "<\#146>")
    Call DoFindReplaceMain("–", "<\#150>")
    Call DoFindReplaceMain("—", "<\#151>")
    Call DoFindReplaceMain("™", "<\#153>")
    Call DoFindReplaceMain("©", "<\#169>")
    Call DoFindReplaceMain("«", "<\#171>")
    Call DoFindReplaceMain("®", "<\#174>")
    Call DoFindReplaceMain("»", "<\#187>")
' Mark with tags characters of Basic Latin, Baltic, Greek, CE and Tur codepages
    Call DoFindReplaceMain("€", "<@NormalLatin><\#128><@$p>", , True)
    Call DoFindReplaceMain(ChrW(402), "<@NormalLatin><\#131><@$p>", , True)
    Call DoFindReplaceMain(ChrW(710), "<@NormalLatin><\#136><@$p>", , True)
    Call DoFindReplaceMain(ChrW(352), "<@NormalLatin><\#138><@$p>", , True)
    Call DoFindReplaceMain(ChrW(338), "<@NormalLatin><\#140><@$p>", , True)
    Call DoFindReplaceMain(ChrW(381), "<@NormalLatin><\#142><@$p>", , True)
    Call DoFindReplaceMain(ChrW(732), "<@NormalLatin><\#152><@$p>", , True)
    Call DoFindReplaceMain(ChrW(353), "<@NormalLatin><\#154><@$p>", , True)
    Call DoFindReplaceMain(ChrW(339), "<@NormalLatin><\#156><@$p>", , True)
    Call DoFindReplaceMain(ChrW(382), "<@NormalLatin><\#158><@$p>", , True)
    Call DoFindReplaceMain(ChrW(376), "<@NormalLatin><\#159><@$p>", , True)
    Call DoFindReplaceMain(ChrW(161), "<@NormalLatin><\#161><@$p>", , True)
    Call DoFindReplaceMain(ChrW(162), "<@NormalLatin><\#162><@$p>", , True)
    Call DoFindReplaceMain(ChrW(163), "<@NormalLatin><\#163><@$p>", , True)
    Call DoFindReplaceMain(ChrW(165), "<@NormalLatin><\#165><@$p>", , True)
    Call DoFindReplaceMain(ChrW(168), "<@NormalLatin><\#168><@$p>", , True)
    Call DoFindReplaceMain(ChrW(170), "<@NormalLatin><\#170><@$p>", , True)
    Call DoFindReplaceMain(ChrW(175), "<@NormalLatin><\#175><@$p>", , True)
    Call DoFindReplaceMain(ChrW(178), "<@NormalLatin><\#178><@$p>", , True)
    Call DoFindReplaceMain(ChrW(179), "<@NormalLatin><\#179><@$p>", , True)
    Call DoFindReplaceMain(ChrW(180), "<@NormalLatin><\#180><@$p>", , True)
    Call DoFindReplaceMain(ChrW(184), "<@NormalLatin><\#184><@$p>", , True)
    Call DoFindReplaceMain(ChrW(185), "<@NormalLatin><\#185><@$p>", , True)
    Call DoFindReplaceMain(ChrW(186), "<@NormalLatin><\#186><@$p>", , True)
    Call DoFindReplaceMain(ChrW(188), "<@NormalLatin><\#188><@$p>", , True)
    Call DoFindReplaceMain(ChrW(189), "<@NormalLatin><\#189><@$p>", , True)
    Call DoFindReplaceMain(ChrW(190), "<@NormalLatin><\#190><@$p>", , True)
    Call DoFindReplaceMain(ChrW(191), "<@NormalLatin><\#191><@$p>", , True)
    Call DoFindReplaceMain(ChrW(192), "<@NormalLatin><\#192><@$p>", , True)
    Call DoFindReplaceMain(ChrW(193), "<@NormalLatin><\#193><@$p>", , True)
    Call DoFindReplaceMain(ChrW(194), "<@NormalLatin><\#194><@$p>", , True)
    Call DoFindReplaceMain(ChrW(195), "<@NormalLatin><\#195><@$p>", , True)
    Call DoFindReplaceMain(ChrW(196), "<@NormalLatin><\#196><@$p>", , True)
    Call DoFindReplaceMain(ChrW(197), "<@NormalLatin><\#197><@$p>", , True)
    Call DoFindReplaceMain(ChrW(198), "<@NormalLatin><\#198><@$p>", , True)
    Call DoFindReplaceMain(ChrW(199), "<@NormalLatin><\#199><@$p>", , True)
    Call DoFindReplaceMain(ChrW(200), "<@NormalLatin><\#200><@$p>", , True)
    Call DoFindReplaceMain(ChrW(201), "<@NormalLatin><\#201><@$p>", , True)
    Call DoFindReplaceMain(ChrW(202), "<@NormalLatin><\#202><@$p>", , True)
    Call DoFindReplaceMain(ChrW(203), "<@NormalLatin><\#203><@$p>", , True)
    Call DoFindReplaceMain(ChrW(204), "<@NormalLatin><\#204><@$p>", , True)
    Call DoFindReplaceMain(ChrW(205), "<@NormalLatin><\#205><@$p>", , True)
    Call DoFindReplaceMain(ChrW(206), "<@NormalLatin><\#206><@$p>", , True)
    Call DoFindReplaceMain(ChrW(207), "<@NormalLatin><\#207><@$p>", , True)
    Call DoFindReplaceMain(ChrW(208), "<@NormalLatin><\#208><@$p>", , True)
    Call DoFindReplaceMain(ChrW(209), "<@NormalLatin><\#209><@$p>", , True)
    Call DoFindReplaceMain(ChrW(210), "<@NormalLatin><\#210><@$p>", , True)
    Call DoFindReplaceMain(ChrW(211), "<@NormalLatin><\#211><@$p>", , True)
    Call DoFindReplaceMain(ChrW(212), "<@NormalLatin><\#212><@$p>", , True)
    Call DoFindReplaceMain(ChrW(213), "<@NormalLatin><\#213><@$p>", , True)
    Call DoFindReplaceMain(ChrW(214), "<@NormalLatin><\#214><@$p>", , True)
    Call DoFindReplaceMain(ChrW(215), "<@NormalLatin><\#215><@$p>", , True)
    Call DoFindReplaceMain(ChrW(216), "<@NormalLatin><\#216><@$p>", , True)
    Call DoFindReplaceMain(ChrW(217), "<@NormalLatin><\#217><@$p>", , True)
    Call DoFindReplaceMain(ChrW(218), "<@NormalLatin><\#218><@$p>", , True)
    Call DoFindReplaceMain(ChrW(219), "<@NormalLatin><\#219><@$p>", , True)
    Call DoFindReplaceMain(ChrW(220), "<@NormalLatin><\#220><@$p>", , True)
    Call DoFindReplaceMain(ChrW(221), "<@NormalLatin><\#221><@$p>", , True)
    Call DoFindReplaceMain(ChrW(222), "<@NormalLatin><\#222><@$p>", , True)
    Call DoFindReplaceMain(ChrW(223), "<@NormalLatin><\#223><@$p>", , True)
    Call DoFindReplaceMain(ChrW(224), "<@NormalLatin><\#224><@$p>", , True)
    Call DoFindReplaceMain(ChrW(225), "<@NormalLatin><\#225><@$p>", , True)
    Call DoFindReplaceMain(ChrW(226), "<@NormalLatin><\#226><@$p>", , True)
    Call DoFindReplaceMain(ChrW(227), "<@NormalLatin><\#227><@$p>", , True)
    Call DoFindReplaceMain(ChrW(228), "<@NormalLatin><\#228><@$p>", , True)
    Call DoFindReplaceMain(ChrW(229), "<@NormalLatin><\#229><@$p>", , True)
    Call DoFindReplaceMain(ChrW(230), "<@NormalLatin><\#230><@$p>", , True)
    Call DoFindReplaceMain(ChrW(231), "<@NormalLatin><\#231><@$p>", , True)
    Call DoFindReplaceMain(ChrW(232), "<@NormalLatin><\#232><@$p>", , True)
    Call DoFindReplaceMain(ChrW(233), "<@NormalLatin><\#233><@$p>", , True)
    Call DoFindReplaceMain(ChrW(234), "<@NormalLatin><\#234><@$p>", , True)
    Call DoFindReplaceMain(ChrW(235), "<@NormalLatin><\#235><@$p>", , True)
    Call DoFindReplaceMain(ChrW(236), "<@NormalLatin><\#236><@$p>", , True)
    Call DoFindReplaceMain(ChrW(237), "<@NormalLatin><\#237><@$p>", , True)
    Call DoFindReplaceMain(ChrW(238), "<@NormalLatin><\#238><@$p>", , True)
    Call DoFindReplaceMain(ChrW(239), "<@NormalLatin><\#239><@$p>", , True)
    Call DoFindReplaceMain(ChrW(240), "<@NormalLatin><\#240><@$p>", , True)
    Call DoFindReplaceMain(ChrW(241), "<@NormalLatin><\#241><@$p>", , True)
    Call DoFindReplaceMain(ChrW(242), "<@NormalLatin><\#242><@$p>", , True)
    Call DoFindReplaceMain(ChrW(243), "<@NormalLatin><\#243><@$p>", , True)
    Call DoFindReplaceMain(ChrW(244), "<@NormalLatin><\#244><@$p>", , True)
    Call DoFindReplaceMain(ChrW(245), "<@NormalLatin><\#245><@$p>", , True)
    Call DoFindReplaceMain(ChrW(246), "<@NormalLatin><\#246><@$p>", , True)
    Call DoFindReplaceMain(ChrW(247), "<@NormalLatin><\#247><@$p>", , True)
    Call DoFindReplaceMain(ChrW(248), "<@NormalLatin><\#248><@$p>", , True)
    Call DoFindReplaceMain(ChrW(249), "<@NormalLatin><\#249><@$p>", , True)
    Call DoFindReplaceMain(ChrW(250), "<@NormalLatin><\#250><@$p>", , True)
    Call DoFindReplaceMain(ChrW(251), "<@NormalLatin><\#251><@$p>", , True)
    Call DoFindReplaceMain(ChrW(252), "<@NormalLatin><\#252><@$p>", , True)
    Call DoFindReplaceMain(ChrW(253), "<@NormalLatin><\#253><@$p>", , True)
    Call DoFindReplaceMain(ChrW(254), "<@NormalLatin><\#254><@$p>", , True)
    Call DoFindReplaceMain(ChrW(255), "<@NormalLatin><\#255><@$p>", , True)
    Call DoFindReplaceMain(ChrW(711), "<@NormalBaltic><\#142><@$p>", , True)
    Call DoFindReplaceMain(ChrW(731), "<@NormalBaltic><\#158><@$p>", , True)
    Call DoFindReplaceMain(ChrW(342), "<@NormalBaltic><\#170><@$p>", , True)
    Call DoFindReplaceMain(ChrW(343), "<@NormalBaltic><\#186><@$p>", , True)
    Call DoFindReplaceMain(ChrW(260), "<@NormalBaltic><\#192><@$p>", , True)
    Call DoFindReplaceMain(ChrW(302), "<@NormalBaltic><\#193><@$p>", , True)
    Call DoFindReplaceMain(ChrW(256), "<@NormalBaltic><\#194><@$p>", , True)
    Call DoFindReplaceMain(ChrW(262), "<@NormalBaltic><\#195><@$p>", , True)
    Call DoFindReplaceMain(ChrW(280), "<@NormalBaltic><\#198><@$p>", , True)
    Call DoFindReplaceMain(ChrW(274), "<@NormalBaltic><\#199><@$p>", , True)
    Call DoFindReplaceMain(ChrW(268), "<@NormalBaltic><\#200><@$p>", , True)
    Call DoFindReplaceMain(ChrW(377), "<@NormalBaltic><\#202><@$p>", , True)
    Call DoFindReplaceMain(ChrW(278), "<@NormalBaltic><\#203><@$p>", , True)
    Call DoFindReplaceMain(ChrW(290), "<@NormalBaltic><\#204><@$p>", , True)
    Call DoFindReplaceMain(ChrW(310), "<@NormalBaltic><\#205><@$p>", , True)
    Call DoFindReplaceMain(ChrW(298), "<@NormalBaltic><\#206><@$p>", , True)
    Call DoFindReplaceMain(ChrW(315), "<@NormalBaltic><\#207><@$p>", , True)
    Call DoFindReplaceMain(ChrW(323), "<@NormalBaltic><\#209><@$p>", , True)
    Call DoFindReplaceMain(ChrW(325), "<@NormalBaltic><\#210><@$p>", , True)
    Call DoFindReplaceMain(ChrW(370), "<@NormalBaltic><\#216><@$p>", , True)
    Call DoFindReplaceMain(ChrW(321), "<@NormalBaltic><\#217><@$p>", , True)
    Call DoFindReplaceMain(ChrW(346), "<@NormalBaltic><\#218><@$p>", , True)
    Call DoFindReplaceMain(ChrW(362), "<@NormalBaltic><\#219><@$p>", , True)
    Call DoFindReplaceMain(ChrW(379), "<@NormalBaltic><\#221><@$p>", , True)
    Call DoFindReplaceMain(ChrW(261), "<@NormalBaltic><\#224><@$p>", , True)
    Call DoFindReplaceMain(ChrW(303), "<@NormalBaltic><\#225><@$p>", , True)
    Call DoFindReplaceMain(ChrW(257), "<@NormalBaltic><\#226><@$p>", , True)
    Call DoFindReplaceMain(ChrW(263), "<@NormalBaltic><\#227><@$p>", , True)
    Call DoFindReplaceMain(ChrW(281), "<@NormalBaltic><\#230><@$p>", , True)
    Call DoFindReplaceMain(ChrW(275), "<@NormalBaltic><\#231><@$p>", , True)
    Call DoFindReplaceMain(ChrW(269), "<@NormalBaltic><\#232><@$p>", , True)
    Call DoFindReplaceMain(ChrW(378), "<@NormalBaltic><\#234><@$p>", , True)
    Call DoFindReplaceMain(ChrW(279), "<@NormalBaltic><\#235><@$p>", , True)
    Call DoFindReplaceMain(ChrW(291), "<@NormalBaltic><\#236><@$p>", , True)
    Call DoFindReplaceMain(ChrW(311), "<@NormalBaltic><\#237><@$p>", , True)
    Call DoFindReplaceMain(ChrW(299), "<@NormalBaltic><\#238><@$p>", , True)
    Call DoFindReplaceMain(ChrW(316), "<@NormalBaltic><\#239><@$p>", , True)
    Call DoFindReplaceMain(ChrW(324), "<@NormalBaltic><\#241><@$p>", , True)
    Call DoFindReplaceMain(ChrW(326), "<@NormalBaltic><\#242><@$p>", , True)
    Call DoFindReplaceMain(ChrW(333), "<@NormalBaltic><\#244><@$p>", , True)
    Call DoFindReplaceMain(ChrW(371), "<@NormalBaltic><\#248><@$p>", , True)
    Call DoFindReplaceMain(ChrW(322), "<@NormalBaltic><\#249><@$p>", , True)
    Call DoFindReplaceMain(ChrW(347), "<@NormalBaltic><\#250><@$p>", , True)
    Call DoFindReplaceMain(ChrW(363), "<@NormalBaltic><\#251><@$p>", , True)
    Call DoFindReplaceMain(ChrW(380), "<@NormalBaltic><\#253><@$p>", , True)
    Call DoFindReplaceMain(ChrW(729), "<@NormalBaltic><\#255><@$p>", , True)
    Call DoFindReplaceMain(ChrW(901), "<@NormalGreek><\#161><@$p>", , True)
    Call DoFindReplaceMain(ChrW(902), "<@NormalGreek><\#162><@$p>", , True)
    Call DoFindReplaceMain(ChrW(904), "<@NormalGreek><\#184><@$p>", , True)
    Call DoFindReplaceMain(ChrW(905), "<@NormalGreek><\#185><@$p>", , True)
    Call DoFindReplaceMain(ChrW(906), "<@NormalGreek><\#186><@$p>", , True)
    Call DoFindReplaceMain(ChrW(908), "<@NormalGreek><\#188><@$p>", , True)
    Call DoFindReplaceMain(ChrW(910), "<@NormalGreek><\#190><@$p>", , True)
    Call DoFindReplaceMain(ChrW(911), "<@NormalGreek><\#191><@$p>", , True)
    Call DoFindReplaceMain(ChrW(912), "<@NormalGreek><\#192><@$p>", , True)
    Call DoFindReplaceMain(ChrW(913), "<@NormalGreek><\#193><@$p>", , True)
    Call DoFindReplaceMain(ChrW(914), "<@NormalGreek><\#194><@$p>", , True)
    Call DoFindReplaceMain(ChrW(915), "<@NormalGreek><\#195><@$p>", , True)
    Call DoFindReplaceMain(ChrW(916), "<@NormalGreek><\#196><@$p>", , True)
    Call DoFindReplaceMain(ChrW(917), "<@NormalGreek><\#197><@$p>", , True)
    Call DoFindReplaceMain(ChrW(918), "<@NormalGreek><\#198><@$p>", , True)
    Call DoFindReplaceMain(ChrW(919), "<@NormalGreek><\#199><@$p>", , True)
    Call DoFindReplaceMain(ChrW(920), "<@NormalGreek><\#200><@$p>", , True)
    Call DoFindReplaceMain(ChrW(921), "<@NormalGreek><\#201><@$p>", , True)
    Call DoFindReplaceMain(ChrW(922), "<@NormalGreek><\#202><@$p>", , True)
    Call DoFindReplaceMain(ChrW(923), "<@NormalGreek><\#203><@$p>", , True)
    Call DoFindReplaceMain(ChrW(924), "<@NormalGreek><\#204><@$p>", , True)
    Call DoFindReplaceMain(ChrW(925), "<@NormalGreek><\#205><@$p>", , True)
    Call DoFindReplaceMain(ChrW(926), "<@NormalGreek><\#206><@$p>", , True)
    Call DoFindReplaceMain(ChrW(927), "<@NormalGreek><\#207><@$p>", , True)
    Call DoFindReplaceMain(ChrW(928), "<@NormalGreek><\#208><@$p>", , True)
    Call DoFindReplaceMain(ChrW(929), "<@NormalGreek><\#209><@$p>", , True)
    Call DoFindReplaceMain(ChrW(931), "<@NormalGreek><\#211><@$p>", , True)
    Call DoFindReplaceMain(ChrW(932), "<@NormalGreek><\#212><@$p>", , True)
    Call DoFindReplaceMain(ChrW(933), "<@NormalGreek><\#213><@$p>", , True)
    Call DoFindReplaceMain(ChrW(934), "<@NormalGreek><\#214><@$p>", , True)
    Call DoFindReplaceMain(ChrW(935), "<@NormalGreek><\#215><@$p>", , True)
    Call DoFindReplaceMain(ChrW(936), "<@NormalGreek><\#216><@$p>", , True)
    Call DoFindReplaceMain(ChrW(937), "<@NormalGreek><\#217><@$p>", , True)
    Call DoFindReplaceMain(ChrW(938), "<@NormalGreek><\#218><@$p>", , True)
    Call DoFindReplaceMain(ChrW(939), "<@NormalGreek><\#219><@$p>", , True)
    Call DoFindReplaceMain(ChrW(940), "<@NormalGreek><\#220><@$p>", , True)
    Call DoFindReplaceMain(ChrW(941), "<@NormalGreek><\#221><@$p>", , True)
    Call DoFindReplaceMain(ChrW(942), "<@NormalGreek><\#222><@$p>", , True)
    Call DoFindReplaceMain(ChrW(943), "<@NormalGreek><\#223><@$p>", , True)
    Call DoFindReplaceMain(ChrW(944), "<@NormalGreek><\#224><@$p>", , True)
    Call DoFindReplaceMain(ChrW(945), "<@NormalGreek><\#225><@$p>", , True)
    Call DoFindReplaceMain(ChrW(946), "<@NormalGreek><\#226><@$p>", , True)
    Call DoFindReplaceMain(ChrW(947), "<@NormalGreek><\#227><@$p>", , True)
    Call DoFindReplaceMain(ChrW(948), "<@NormalGreek><\#228><@$p>", , True)
    Call DoFindReplaceMain(ChrW(949), "<@NormalGreek><\#229><@$p>", , True)
    Call DoFindReplaceMain(ChrW(950), "<@NormalGreek><\#230><@$p>", , True)
    Call DoFindReplaceMain(ChrW(951), "<@NormalGreek><\#231><@$p>", , True)
    Call DoFindReplaceMain(ChrW(952), "<@NormalGreek><\#232><@$p>", , True)
    Call DoFindReplaceMain(ChrW(953), "<@NormalGreek><\#233><@$p>", , True)
    Call DoFindReplaceMain(ChrW(954), "<@NormalGreek><\#234><@$p>", , True)
    Call DoFindReplaceMain(ChrW(955), "<@NormalGreek><\#235><@$p>", , True)
    Call DoFindReplaceMain(ChrW(956), "<@NormalGreek><\#236><@$p>", , True)
    Call DoFindReplaceMain(ChrW(957), "<@NormalGreek><\#237><@$p>", , True)
    Call DoFindReplaceMain(ChrW(958), "<@NormalGreek><\#238><@$p>", , True)
    Call DoFindReplaceMain(ChrW(959), "<@NormalGreek><\#239><@$p>", , True)
    Call DoFindReplaceMain(ChrW(960), "<@NormalGreek><\#240><@$p>", , True)
    Call DoFindReplaceMain(ChrW(961), "<@NormalGreek><\#241><@$p>", , True)
    Call DoFindReplaceMain(ChrW(962), "<@NormalGreek><\#242><@$p>", , True)
    Call DoFindReplaceMain(ChrW(963), "<@NormalGreek><\#243><@$p>", , True)
    Call DoFindReplaceMain(ChrW(964), "<@NormalGreek><\#244><@$p>", , True)
    Call DoFindReplaceMain(ChrW(965), "<@NormalGreek><\#245><@$p>", , True)
    Call DoFindReplaceMain(ChrW(966), "<@NormalGreek><\#246><@$p>", , True)
    Call DoFindReplaceMain(ChrW(967), "<@NormalGreek><\#247><@$p>", , True)
    Call DoFindReplaceMain(ChrW(968), "<@NormalGreek><\#248><@$p>", , True)
    Call DoFindReplaceMain(ChrW(969), "<@NormalGreek><\#249><@$p>", , True)
    Call DoFindReplaceMain(ChrW(970), "<@NormalGreek><\#250><@$p>", , True)
    Call DoFindReplaceMain(ChrW(971), "<@NormalGreek><\#251><@$p>", , True)
    Call DoFindReplaceMain(ChrW(972), "<@NormalGreek><\#252><@$p>", , True)
    Call DoFindReplaceMain(ChrW(973), "<@NormalGreek><\#253><@$p>", , True)
    Call DoFindReplaceMain(ChrW(974), "<@NormalGreek><\#254><@$p>", , True)
    Call DoFindReplaceMain(ChrW(356), "<@NormalCE><\#141><@$p>", , True)
    Call DoFindReplaceMain(ChrW(357), "<@NormalCE><\#157><@$p>", , True)
    Call DoFindReplaceMain(ChrW(728), "<@NormalCE><\#162><@$p>", , True)
    Call DoFindReplaceMain(ChrW(350), "<@NormalCE><\#170><@$p>", , True)
    Call DoFindReplaceMain(ChrW(351), "<@NormalCE><\#186><@$p>", , True)
    Call DoFindReplaceMain(ChrW(317), "<@NormalCE><\#188><@$p>", , True)
    Call DoFindReplaceMain(ChrW(733), "<@NormalCE><\#189><@$p>", , True)
    Call DoFindReplaceMain(ChrW(318), "<@NormalCE><\#190><@$p>", , True)
    Call DoFindReplaceMain(ChrW(340), "<@NormalCE><\#192><@$p>", , True)
    Call DoFindReplaceMain(ChrW(258), "<@NormalCE><\#195><@$p>", , True)
    Call DoFindReplaceMain(ChrW(313), "<@NormalCE><\#197><@$p>", , True)
    Call DoFindReplaceMain(ChrW(282), "<@NormalCE><\#204><@$p>", , True)
    Call DoFindReplaceMain(ChrW(270), "<@NormalCE><\#207><@$p>", , True)
    Call DoFindReplaceMain(ChrW(327), "<@NormalCE><\#210><@$p>", , True)
    Call DoFindReplaceMain(ChrW(336), "<@NormalCE><\#213><@$p>", , True)
    Call DoFindReplaceMain(ChrW(344), "<@NormalCE><\#216><@$p>", , True)
    Call DoFindReplaceMain(ChrW(366), "<@NormalCE><\#217><@$p>", , True)
    Call DoFindReplaceMain(ChrW(368), "<@NormalCE><\#219><@$p>", , True)
    Call DoFindReplaceMain(ChrW(354), "<@NormalCE><\#222><@$p>", , True)
    Call DoFindReplaceMain(ChrW(341), "<@NormalCE><\#224><@$p>", , True)
    Call DoFindReplaceMain(ChrW(259), "<@NormalCE><\#227><@$p>", , True)
    Call DoFindReplaceMain(ChrW(314), "<@NormalCE><\#229><@$p>", , True)
    Call DoFindReplaceMain(ChrW(283), "<@NormalCE><\#236><@$p>", , True)
    Call DoFindReplaceMain(ChrW(271), "<@NormalCE><\#239><@$p>", , True)
    Call DoFindReplaceMain(ChrW(273), "<@NormalCE><\#240><@$p>", , True)
    Call DoFindReplaceMain(ChrW(328), "<@NormalCE><\#242><@$p>", , True)
    Call DoFindReplaceMain(ChrW(337), "<@NormalCE><\#245><@$p>", , True)
    Call DoFindReplaceMain(ChrW(345), "<@NormalCE><\#248><@$p>", , True)
    Call DoFindReplaceMain(ChrW(367), "<@NormalCE><\#249><@$p>", , True)
    Call DoFindReplaceMain(ChrW(369), "<@NormalCE><\#251><@$p>", , True)
    Call DoFindReplaceMain(ChrW(355), "<@NormalCE><\#254><@$p>", , True)
    Call DoFindReplaceMain(ChrW(286), "<@NormalTur><\#208><@$p>", , True)
    Call DoFindReplaceMain(ChrW(304), "<@NormalTur><\#221><@$p>", , True)
    Call DoFindReplaceMain(ChrW(287), "<@NormalTur><\#240><@$p>", , True)
    Call DoFindReplaceMain(ChrW(305), "<@NormalTur><\#253><@$p>", , True)
    Application.Run MacroName:="AddCharacterTagNote"
End Sub
Sub AddCharacterTagNote()
    Call DoFindReplaceNote("^s", "<\!s>")
    Call DoFindReplaceNote("^~", "<\!->")
    Call DoFindReplaceMain(ChrW(8213), "<\#150>")
    Call DoFindReplaceNote(ChrW(8220), "<\#147>")
    Call DoFindReplaceNote(ChrW(8221), "<\#148>")
    Call DoFindReplaceNote(ChrW(8222), "<\#132>")
    Call DoFindReplaceNote("‚", "<\#130>")
    Call DoFindReplaceNote("…", "<\#133>")
    Call DoFindReplaceNote("‘", "<\#145>")
    Call DoFindReplaceNote("’", "<\#146>")
    Call DoFindReplaceNote("–", "<\#150>")
    Call DoFindReplaceNote("—", "<\#151>")
    Call DoFindReplaceNote("™", "<\#153>")
    Call DoFindReplaceNote("©", "<\#169>")
    Call DoFindReplaceNote("«", "<\#171>")
    Call DoFindReplaceNote("®", "<\#174>")
    Call DoFindReplaceNote("»", "<\#187>")
' Mark with tags characters of Basic Latin, Baltic, Greek, CE and Tur codepages
    Call DoFindReplaceNote("€", "<@NormalLatinSmall><\#128><@$p>", , True)
    Call DoFindReplaceNote(ChrW(402), "<@NormalLatinSmall><\#131><@$p>", , True)
    Call DoFindReplaceNote(ChrW(710), "<@NormalLatinSmall><\#136><@$p>", , True)
    Call DoFindReplaceNote(ChrW(352), "<@NormalLatinSmall><\#138><@$p>", , True)
    Call DoFindReplaceNote(ChrW(338), "<@NormalLatinSmall><\#140><@$p>", , True)
    Call DoFindReplaceNote(ChrW(381), "<@NormalLatinSmall><\#142><@$p>", , True)
    Call DoFindReplaceNote(ChrW(732), "<@NormalLatinSmall><\#152><@$p>", , True)
    Call DoFindReplaceNote(ChrW(353), "<@NormalLatinSmall><\#154><@$p>", , True)
    Call DoFindReplaceNote(ChrW(339), "<@NormalLatinSmall><\#156><@$p>", , True)
    Call DoFindReplaceNote(ChrW(382), "<@NormalLatinSmall><\#158><@$p>", , True)
    Call DoFindReplaceNote(ChrW(376), "<@NormalLatinSmall><\#159><@$p>", , True)
    Call DoFindReplaceNote(ChrW(161), "<@NormalLatinSmall><\#161><@$p>", , True)
    Call DoFindReplaceNote(ChrW(162), "<@NormalLatinSmall><\#162><@$p>", , True)
    Call DoFindReplaceNote(ChrW(163), "<@NormalLatinSmall><\#163><@$p>", , True)
    Call DoFindReplaceNote(ChrW(165), "<@NormalLatinSmall><\#165><@$p>", , True)
    Call DoFindReplaceNote(ChrW(168), "<@NormalLatinSmall><\#168><@$p>", , True)
    Call DoFindReplaceNote(ChrW(170), "<@NormalLatinSmall><\#170><@$p>", , True)
    Call DoFindReplaceNote(ChrW(175), "<@NormalLatinSmall><\#175><@$p>", , True)
    Call DoFindReplaceNote(ChrW(178), "<@NormalLatinSmall><\#178><@$p>", , True)
    Call DoFindReplaceNote(ChrW(179), "<@NormalLatinSmall><\#179><@$p>", , True)
    Call DoFindReplaceNote(ChrW(180), "<@NormalLatinSmall><\#180><@$p>", , True)
    Call DoFindReplaceNote(ChrW(184), "<@NormalLatinSmall><\#184><@$p>", , True)
    Call DoFindReplaceNote(ChrW(185), "<@NormalLatinSmall><\#185><@$p>", , True)
    Call DoFindReplaceNote(ChrW(186), "<@NormalLatinSmall><\#186><@$p>", , True)
    Call DoFindReplaceNote(ChrW(188), "<@NormalLatinSmall><\#188><@$p>", , True)
    Call DoFindReplaceNote(ChrW(189), "<@NormalLatinSmall><\#189><@$p>", , True)
    Call DoFindReplaceNote(ChrW(190), "<@NormalLatinSmall><\#190><@$p>", , True)
    Call DoFindReplaceNote(ChrW(191), "<@NormalLatinSmall><\#191><@$p>", , True)
    Call DoFindReplaceNote(ChrW(192), "<@NormalLatinSmall><\#192><@$p>", , True)
    Call DoFindReplaceNote(ChrW(193), "<@NormalLatinSmall><\#193><@$p>", , True)
    Call DoFindReplaceNote(ChrW(194), "<@NormalLatinSmall><\#194><@$p>", , True)
    Call DoFindReplaceNote(ChrW(195), "<@NormalLatinSmall><\#195><@$p>", , True)
    Call DoFindReplaceNote(ChrW(196), "<@NormalLatinSmall><\#196><@$p>", , True)
    Call DoFindReplaceNote(ChrW(197), "<@NormalLatinSmall><\#197><@$p>", , True)
    Call DoFindReplaceNote(ChrW(198), "<@NormalLatinSmall><\#198><@$p>", , True)
    Call DoFindReplaceNote(ChrW(199), "<@NormalLatinSmall><\#199><@$p>", , True)
    Call DoFindReplaceNote(ChrW(200), "<@NormalLatinSmall><\#200><@$p>", , True)
    Call DoFindReplaceNote(ChrW(201), "<@NormalLatinSmall><\#201><@$p>", , True)
    Call DoFindReplaceNote(ChrW(202), "<@NormalLatinSmall><\#202><@$p>", , True)
    Call DoFindReplaceNote(ChrW(203), "<@NormalLatinSmall><\#203><@$p>", , True)
    Call DoFindReplaceNote(ChrW(204), "<@NormalLatinSmall><\#204><@$p>", , True)
    Call DoFindReplaceNote(ChrW(205), "<@NormalLatinSmall><\#205><@$p>", , True)
    Call DoFindReplaceNote(ChrW(206), "<@NormalLatinSmall><\#206><@$p>", , True)
    Call DoFindReplaceNote(ChrW(207), "<@NormalLatinSmall><\#207><@$p>", , True)
    Call DoFindReplaceNote(ChrW(208), "<@NormalLatinSmall><\#208><@$p>", , True)
    Call DoFindReplaceNote(ChrW(209), "<@NormalLatinSmall><\#209><@$p>", , True)
    Call DoFindReplaceNote(ChrW(210), "<@NormalLatinSmall><\#210><@$p>", , True)
    Call DoFindReplaceNote(ChrW(211), "<@NormalLatinSmall><\#211><@$p>", , True)
    Call DoFindReplaceNote(ChrW(212), "<@NormalLatinSmall><\#212><@$p>", , True)
    Call DoFindReplaceNote(ChrW(213), "<@NormalLatinSmall><\#213><@$p>", , True)
    Call DoFindReplaceNote(ChrW(214), "<@NormalLatinSmall><\#214><@$p>", , True)
    Call DoFindReplaceNote(ChrW(215), "<@NormalLatinSmall><\#215><@$p>", , True)
    Call DoFindReplaceNote(ChrW(216), "<@NormalLatinSmall><\#216><@$p>", , True)
    Call DoFindReplaceNote(ChrW(217), "<@NormalLatinSmall><\#217><@$p>", , True)
    Call DoFindReplaceNote(ChrW(218), "<@NormalLatinSmall><\#218><@$p>", , True)
    Call DoFindReplaceNote(ChrW(219), "<@NormalLatinSmall><\#219><@$p>", , True)
    Call DoFindReplaceNote(ChrW(220), "<@NormalLatinSmall><\#220><@$p>", , True)
    Call DoFindReplaceNote(ChrW(221), "<@NormalLatinSmall><\#221><@$p>", , True)
    Call DoFindReplaceNote(ChrW(222), "<@NormalLatinSmall><\#222><@$p>", , True)
    Call DoFindReplaceNote(ChrW(223), "<@NormalLatinSmall><\#223><@$p>", , True)
    Call DoFindReplaceNote(ChrW(224), "<@NormalLatinSmall><\#224><@$p>", , True)
    Call DoFindReplaceNote(ChrW(225), "<@NormalLatinSmall><\#225><@$p>", , True)
    Call DoFindReplaceNote(ChrW(226), "<@NormalLatinSmall><\#226><@$p>", , True)
    Call DoFindReplaceNote(ChrW(227), "<@NormalLatinSmall><\#227><@$p>", , True)
    Call DoFindReplaceNote(ChrW(228), "<@NormalLatinSmall><\#228><@$p>", , True)
    Call DoFindReplaceNote(ChrW(229), "<@NormalLatinSmall><\#229><@$p>", , True)
    Call DoFindReplaceNote(ChrW(230), "<@NormalLatinSmall><\#230><@$p>", , True)
    Call DoFindReplaceNote(ChrW(231), "<@NormalLatinSmall><\#231><@$p>", , True)
    Call DoFindReplaceNote(ChrW(232), "<@NormalLatinSmall><\#232><@$p>", , True)
    Call DoFindReplaceNote(ChrW(233), "<@NormalLatinSmall><\#233><@$p>", , True)
    Call DoFindReplaceNote(ChrW(234), "<@NormalLatinSmall><\#234><@$p>", , True)
    Call DoFindReplaceNote(ChrW(235), "<@NormalLatinSmall><\#235><@$p>", , True)
    Call DoFindReplaceNote(ChrW(236), "<@NormalLatinSmall><\#236><@$p>", , True)
    Call DoFindReplaceNote(ChrW(237), "<@NormalLatinSmall><\#237><@$p>", , True)
    Call DoFindReplaceNote(ChrW(238), "<@NormalLatinSmall><\#238><@$p>", , True)
    Call DoFindReplaceNote(ChrW(239), "<@NormalLatinSmall><\#239><@$p>", , True)
    Call DoFindReplaceNote(ChrW(240), "<@NormalLatinSmall><\#240><@$p>", , True)
    Call DoFindReplaceNote(ChrW(241), "<@NormalLatinSmall><\#241><@$p>", , True)
    Call DoFindReplaceNote(ChrW(242), "<@NormalLatinSmall><\#242><@$p>", , True)
    Call DoFindReplaceNote(ChrW(243), "<@NormalLatinSmall><\#243><@$p>", , True)
    Call DoFindReplaceNote(ChrW(244), "<@NormalLatinSmall><\#244><@$p>", , True)
    Call DoFindReplaceNote(ChrW(245), "<@NormalLatinSmall><\#245><@$p>", , True)
    Call DoFindReplaceNote(ChrW(246), "<@NormalLatinSmall><\#246><@$p>", , True)
    Call DoFindReplaceNote(ChrW(247), "<@NormalLatinSmall><\#247><@$p>", , True)
    Call DoFindReplaceNote(ChrW(248), "<@NormalLatinSmall><\#248><@$p>", , True)
    Call DoFindReplaceNote(ChrW(249), "<@NormalLatinSmall><\#249><@$p>", , True)
    Call DoFindReplaceNote(ChrW(250), "<@NormalLatinSmall><\#250><@$p>", , True)
    Call DoFindReplaceNote(ChrW(251), "<@NormalLatinSmall><\#251><@$p>", , True)
    Call DoFindReplaceNote(ChrW(252), "<@NormalLatinSmall><\#252><@$p>", , True)
    Call DoFindReplaceNote(ChrW(253), "<@NormalLatinSmall><\#253><@$p>", , True)
    Call DoFindReplaceNote(ChrW(254), "<@NormalLatinSmall><\#254><@$p>", , True)
    Call DoFindReplaceNote(ChrW(255), "<@NormalLatinSmall><\#255><@$p>", , True)
    Call DoFindReplaceNote(ChrW(711), "<@NormalBalticSmall><\#142><@$p>", , True)
    Call DoFindReplaceNote(ChrW(731), "<@NormalBalticSmall><\#158><@$p>", , True)
    Call DoFindReplaceNote(ChrW(342), "<@NormalBalticSmall><\#170><@$p>", , True)
    Call DoFindReplaceNote(ChrW(343), "<@NormalBalticSmall><\#186><@$p>", , True)
    Call DoFindReplaceNote(ChrW(260), "<@NormalBalticSmall><\#192><@$p>", , True)
    Call DoFindReplaceNote(ChrW(302), "<@NormalBalticSmall><\#193><@$p>", , True)
    Call DoFindReplaceNote(ChrW(256), "<@NormalBalticSmall><\#194><@$p>", , True)
    Call DoFindReplaceNote(ChrW(262), "<@NormalBalticSmall><\#195><@$p>", , True)
    Call DoFindReplaceNote(ChrW(280), "<@NormalBalticSmall><\#198><@$p>", , True)
    Call DoFindReplaceNote(ChrW(274), "<@NormalBalticSmall><\#199><@$p>", , True)
    Call DoFindReplaceNote(ChrW(268), "<@NormalBalticSmall><\#200><@$p>", , True)
    Call DoFindReplaceNote(ChrW(377), "<@NormalBalticSmall><\#202><@$p>", , True)
    Call DoFindReplaceNote(ChrW(278), "<@NormalBalticSmall><\#203><@$p>", , True)
    Call DoFindReplaceNote(ChrW(290), "<@NormalBalticSmall><\#204><@$p>", , True)
    Call DoFindReplaceNote(ChrW(310), "<@NormalBalticSmall><\#205><@$p>", , True)
    Call DoFindReplaceNote(ChrW(298), "<@NormalBalticSmall><\#206><@$p>", , True)
    Call DoFindReplaceNote(ChrW(315), "<@NormalBalticSmall><\#207><@$p>", , True)
    Call DoFindReplaceNote(ChrW(323), "<@NormalBalticSmall><\#209><@$p>", , True)
    Call DoFindReplaceNote(ChrW(325), "<@NormalBalticSmall><\#210><@$p>", , True)
    Call DoFindReplaceNote(ChrW(370), "<@NormalBalticSmall><\#216><@$p>", , True)
    Call DoFindReplaceNote(ChrW(321), "<@NormalBalticSmall><\#217><@$p>", , True)
    Call DoFindReplaceNote(ChrW(346), "<@NormalBalticSmall><\#218><@$p>", , True)
    Call DoFindReplaceNote(ChrW(362), "<@NormalBalticSmall><\#219><@$p>", , True)
    Call DoFindReplaceNote(ChrW(379), "<@NormalBalticSmall><\#221><@$p>", , True)
    Call DoFindReplaceNote(ChrW(261), "<@NormalBalticSmall><\#224><@$p>", , True)
    Call DoFindReplaceNote(ChrW(303), "<@NormalBalticSmall><\#225><@$p>", , True)
    Call DoFindReplaceNote(ChrW(257), "<@NormalBalticSmall><\#226><@$p>", , True)
    Call DoFindReplaceNote(ChrW(263), "<@NormalBalticSmall><\#227><@$p>", , True)
    Call DoFindReplaceNote(ChrW(281), "<@NormalBalticSmall><\#230><@$p>", , True)
    Call DoFindReplaceNote(ChrW(275), "<@NormalBalticSmall><\#231><@$p>", , True)
    Call DoFindReplaceNote(ChrW(269), "<@NormalBalticSmall><\#232><@$p>", , True)
    Call DoFindReplaceNote(ChrW(378), "<@NormalBalticSmall><\#234><@$p>", , True)
    Call DoFindReplaceNote(ChrW(279), "<@NormalBalticSmall><\#235><@$p>", , True)
    Call DoFindReplaceNote(ChrW(291), "<@NormalBalticSmall><\#236><@$p>", , True)
    Call DoFindReplaceNote(ChrW(311), "<@NormalBalticSmall><\#237><@$p>", , True)
    Call DoFindReplaceNote(ChrW(299), "<@NormalBalticSmall><\#238><@$p>", , True)
    Call DoFindReplaceNote(ChrW(316), "<@NormalBalticSmall><\#239><@$p>", , True)
    Call DoFindReplaceNote(ChrW(324), "<@NormalBalticSmall><\#241><@$p>", , True)
    Call DoFindReplaceNote(ChrW(326), "<@NormalBalticSmall><\#242><@$p>", , True)
    Call DoFindReplaceNote(ChrW(333), "<@NormalBalticSmall><\#244><@$p>", , True)
    Call DoFindReplaceNote(ChrW(371), "<@NormalBalticSmall><\#248><@$p>", , True)
    Call DoFindReplaceNote(ChrW(322), "<@NormalBalticSmall><\#249><@$p>", , True)
    Call DoFindReplaceNote(ChrW(347), "<@NormalBalticSmall><\#250><@$p>", , True)
    Call DoFindReplaceNote(ChrW(363), "<@NormalBalticSmall><\#251><@$p>", , True)
    Call DoFindReplaceNote(ChrW(380), "<@NormalBalticSmall><\#253><@$p>", , True)
    Call DoFindReplaceNote(ChrW(729), "<@NormalBalticSmall><\#255><@$p>", , True)
    Call DoFindReplaceNote(ChrW(901), "<@NormalGreekSmall><\#161><@$p>", , True)
    Call DoFindReplaceNote(ChrW(902), "<@NormalGreekSmall><\#162><@$p>", , True)
    Call DoFindReplaceNote(ChrW(904), "<@NormalGreekSmall><\#184><@$p>", , True)
    Call DoFindReplaceNote(ChrW(905), "<@NormalGreekSmall><\#185><@$p>", , True)
    Call DoFindReplaceNote(ChrW(906), "<@NormalGreekSmall><\#186><@$p>", , True)
    Call DoFindReplaceNote(ChrW(908), "<@NormalGreekSmall><\#188><@$p>", , True)
    Call DoFindReplaceNote(ChrW(910), "<@NormalGreekSmall><\#190><@$p>", , True)
    Call DoFindReplaceNote(ChrW(911), "<@NormalGreekSmall><\#191><@$p>", , True)
    Call DoFindReplaceNote(ChrW(912), "<@NormalGreekSmall><\#192><@$p>", , True)
    Call DoFindReplaceNote(ChrW(913), "<@NormalGreekSmall><\#193><@$p>", , True)
    Call DoFindReplaceNote(ChrW(914), "<@NormalGreekSmall><\#194><@$p>", , True)
    Call DoFindReplaceNote(ChrW(915), "<@NormalGreekSmall><\#195><@$p>", , True)
    Call DoFindReplaceNote(ChrW(916), "<@NormalGreekSmall><\#196><@$p>", , True)
    Call DoFindReplaceNote(ChrW(917), "<@NormalGreekSmall><\#197><@$p>", , True)
    Call DoFindReplaceNote(ChrW(918), "<@NormalGreekSmall><\#198><@$p>", , True)
    Call DoFindReplaceNote(ChrW(919), "<@NormalGreekSmall><\#199><@$p>", , True)
    Call DoFindReplaceNote(ChrW(920), "<@NormalGreekSmall><\#200><@$p>", , True)
    Call DoFindReplaceNote(ChrW(921), "<@NormalGreekSmall><\#201><@$p>", , True)
    Call DoFindReplaceNote(ChrW(922), "<@NormalGreekSmall><\#202><@$p>", , True)
    Call DoFindReplaceNote(ChrW(923), "<@NormalGreekSmall><\#203><@$p>", , True)
    Call DoFindReplaceNote(ChrW(924), "<@NormalGreekSmall><\#204><@$p>", , True)
    Call DoFindReplaceNote(ChrW(925), "<@NormalGreekSmall><\#205><@$p>", , True)
    Call DoFindReplaceNote(ChrW(926), "<@NormalGreekSmall><\#206><@$p>", , True)
    Call DoFindReplaceNote(ChrW(927), "<@NormalGreekSmall><\#207><@$p>", , True)
    Call DoFindReplaceNote(ChrW(928), "<@NormalGreekSmall><\#208><@$p>", , True)
    Call DoFindReplaceNote(ChrW(929), "<@NormalGreekSmall><\#209><@$p>", , True)
    Call DoFindReplaceNote(ChrW(931), "<@NormalGreekSmall><\#211><@$p>", , True)
    Call DoFindReplaceNote(ChrW(932), "<@NormalGreekSmall><\#212><@$p>", , True)
    Call DoFindReplaceNote(ChrW(933), "<@NormalGreekSmall><\#213><@$p>", , True)
    Call DoFindReplaceNote(ChrW(934), "<@NormalGreekSmall><\#214><@$p>", , True)
    Call DoFindReplaceNote(ChrW(935), "<@NormalGreekSmall><\#215><@$p>", , True)
    Call DoFindReplaceNote(ChrW(936), "<@NormalGreekSmall><\#216><@$p>", , True)
    Call DoFindReplaceNote(ChrW(937), "<@NormalGreekSmall><\#217><@$p>", , True)
    Call DoFindReplaceNote(ChrW(938), "<@NormalGreekSmall><\#218><@$p>", , True)
    Call DoFindReplaceNote(ChrW(939), "<@NormalGreekSmall><\#219><@$p>", , True)
    Call DoFindReplaceNote(ChrW(940), "<@NormalGreekSmall><\#220><@$p>", , True)
    Call DoFindReplaceNote(ChrW(941), "<@NormalGreekSmall><\#221><@$p>", , True)
    Call DoFindReplaceNote(ChrW(942), "<@NormalGreekSmall><\#222><@$p>", , True)
    Call DoFindReplaceNote(ChrW(943), "<@NormalGreekSmall><\#223><@$p>", , True)
    Call DoFindReplaceNote(ChrW(944), "<@NormalGreekSmall><\#224><@$p>", , True)
    Call DoFindReplaceNote(ChrW(945), "<@NormalGreekSmall><\#225><@$p>", , True)
    Call DoFindReplaceNote(ChrW(946), "<@NormalGreekSmall><\#226><@$p>", , True)
    Call DoFindReplaceNote(ChrW(947), "<@NormalGreekSmall><\#227><@$p>", , True)
    Call DoFindReplaceNote(ChrW(948), "<@NormalGreekSmall><\#228><@$p>", , True)
    Call DoFindReplaceNote(ChrW(949), "<@NormalGreekSmall><\#229><@$p>", , True)
    Call DoFindReplaceNote(ChrW(950), "<@NormalGreekSmall><\#230><@$p>", , True)
    Call DoFindReplaceNote(ChrW(951), "<@NormalGreekSmall><\#231><@$p>", , True)
    Call DoFindReplaceNote(ChrW(952), "<@NormalGreekSmall><\#232><@$p>", , True)
    Call DoFindReplaceNote(ChrW(953), "<@NormalGreekSmall><\#233><@$p>", , True)
    Call DoFindReplaceNote(ChrW(954), "<@NormalGreekSmall><\#234><@$p>", , True)
    Call DoFindReplaceNote(ChrW(955), "<@NormalGreekSmall><\#235><@$p>", , True)
    Call DoFindReplaceNote(ChrW(956), "<@NormalGreekSmall><\#236><@$p>", , True)
    Call DoFindReplaceNote(ChrW(957), "<@NormalGreekSmall><\#237><@$p>", , True)
    Call DoFindReplaceNote(ChrW(958), "<@NormalGreekSmall><\#238><@$p>", , True)
    Call DoFindReplaceNote(ChrW(959), "<@NormalGreekSmall><\#239><@$p>", , True)
    Call DoFindReplaceNote(ChrW(960), "<@NormalGreekSmall><\#240><@$p>", , True)
    Call DoFindReplaceNote(ChrW(961), "<@NormalGreekSmall><\#241><@$p>", , True)
    Call DoFindReplaceNote(ChrW(962), "<@NormalGreekSmall><\#242><@$p>", , True)
    Call DoFindReplaceNote(ChrW(963), "<@NormalGreekSmall><\#243><@$p>", , True)
    Call DoFindReplaceNote(ChrW(964), "<@NormalGreekSmall><\#244><@$p>", , True)
    Call DoFindReplaceNote(ChrW(965), "<@NormalGreekSmall><\#245><@$p>", , True)
    Call DoFindReplaceNote(ChrW(966), "<@NormalGreekSmall><\#246><@$p>", , True)
    Call DoFindReplaceNote(ChrW(967), "<@NormalGreekSmall><\#247><@$p>", , True)
    Call DoFindReplaceNote(ChrW(968), "<@NormalGreekSmall><\#248><@$p>", , True)
    Call DoFindReplaceNote(ChrW(969), "<@NormalGreekSmall><\#249><@$p>", , True)
    Call DoFindReplaceNote(ChrW(970), "<@NormalGreekSmall><\#250><@$p>", , True)
    Call DoFindReplaceNote(ChrW(971), "<@NormalGreekSmall><\#251><@$p>", , True)
    Call DoFindReplaceNote(ChrW(972), "<@NormalGreekSmall><\#252><@$p>", , True)
    Call DoFindReplaceNote(ChrW(973), "<@NormalGreekSmall><\#253><@$p>", , True)
    Call DoFindReplaceNote(ChrW(974), "<@NormalGreekSmall><\#254><@$p>", , True)
    Call DoFindReplaceNote(ChrW(356), "<@NormalCESmall><\#141><@$p>", , True)
    Call DoFindReplaceNote(ChrW(357), "<@NormalCESmall><\#157><@$p>", , True)
    Call DoFindReplaceNote(ChrW(728), "<@NormalCESmall><\#162><@$p>", , True)
    Call DoFindReplaceNote(ChrW(350), "<@NormalCESmall><\#170><@$p>", , True)
    Call DoFindReplaceNote(ChrW(351), "<@NormalCESmall><\#186><@$p>", , True)
    Call DoFindReplaceNote(ChrW(317), "<@NormalCESmall><\#188><@$p>", , True)
    Call DoFindReplaceNote(ChrW(733), "<@NormalCESmall><\#189><@$p>", , True)
    Call DoFindReplaceNote(ChrW(318), "<@NormalCESmall><\#190><@$p>", , True)
    Call DoFindReplaceNote(ChrW(340), "<@NormalCESmall><\#192><@$p>", , True)
    Call DoFindReplaceNote(ChrW(258), "<@NormalCESmall><\#195><@$p>", , True)
    Call DoFindReplaceNote(ChrW(313), "<@NormalCESmall><\#197><@$p>", , True)
    Call DoFindReplaceNote(ChrW(282), "<@NormalCESmall><\#204><@$p>", , True)
    Call DoFindReplaceNote(ChrW(270), "<@NormalCESmall><\#207><@$p>", , True)
    Call DoFindReplaceNote(ChrW(327), "<@NormalCESmall><\#210><@$p>", , True)
    Call DoFindReplaceNote(ChrW(336), "<@NormalCESmall><\#213><@$p>", , True)
    Call DoFindReplaceNote(ChrW(344), "<@NormalCESmall><\#216><@$p>", , True)
    Call DoFindReplaceNote(ChrW(366), "<@NormalCESmall><\#217><@$p>", , True)
    Call DoFindReplaceNote(ChrW(368), "<@NormalCESmall><\#219><@$p>", , True)
    Call DoFindReplaceNote(ChrW(354), "<@NormalCESmall><\#222><@$p>", , True)
    Call DoFindReplaceNote(ChrW(341), "<@NormalCESmall><\#224><@$p>", , True)
    Call DoFindReplaceNote(ChrW(259), "<@NormalCESmall><\#227><@$p>", , True)
    Call DoFindReplaceNote(ChrW(314), "<@NormalCESmall><\#229><@$p>", , True)
    Call DoFindReplaceNote(ChrW(283), "<@NormalCESmall><\#236><@$p>", , True)
    Call DoFindReplaceNote(ChrW(271), "<@NormalCESmall><\#239><@$p>", , True)
    Call DoFindReplaceNote(ChrW(273), "<@NormalCESmall><\#240><@$p>", , True)
    Call DoFindReplaceNote(ChrW(328), "<@NormalCESmall><\#242><@$p>", , True)
    Call DoFindReplaceNote(ChrW(337), "<@NormalCESmall><\#245><@$p>", , True)
    Call DoFindReplaceNote(ChrW(345), "<@NormalCESmall><\#248><@$p>", , True)
    Call DoFindReplaceNote(ChrW(367), "<@NormalCESmall><\#249><@$p>", , True)
    Call DoFindReplaceNote(ChrW(369), "<@NormalCESmall><\#251><@$p>", , True)
    Call DoFindReplaceNote(ChrW(355), "<@NormalCESmall><\#254><@$p>", , True)
    Call DoFindReplaceNote(ChrW(286), "<@NormalTurSmall><\#208><@$p>", , True)
    Call DoFindReplaceNote(ChrW(304), "<@NormalTurSmall><\#221><@$p>", , True)
    Call DoFindReplaceNote(ChrW(287), "<@NormalTurSmall><\#240><@$p>", , True)
    Call DoFindReplaceNote(ChrW(305), "<@NormalTurSmall><\#253><@$p>", , True)
    Application.Run MacroName:="AddFormatTag"
End Sub
Sub AddFormatTag()
' Format MainText
ActiveDocument.StoryRanges(wdMainTextStory).Select
    Selection.Find.ClearFormatting
    Selection.Find.Font.Italic = True
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find.Replacement.Font
        .Bold = False
        .Italic = False
    End With
    With Selection.Find
        .Text = "^p"
        .Replacement.Text = "^p"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Selection.Find.ClearFormatting
    Selection.Find.Font.Bold = True
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find.Replacement.Font
        .Bold = False
        .Italic = False
    End With
    With Selection.Find
        .Text = "^p"
        .Replacement.Text = "^p"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Selection.Find.ClearFormatting
    Selection.Find.Font.Italic = True
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = ""
        .Replacement.Text = "<I>^&<I>"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Selection.Find.ClearFormatting
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = "<I>^p<I>"
        .Replacement.Text = "^p"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Selection.Find.ClearFormatting
    Selection.Find.Font.Bold = True
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = ""
        .Replacement.Text = "<B>^&<B>"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Selection.Find.ClearFormatting
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = "<B>^p<B>"
        .Replacement.Text = "^p"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Selection.Find.ClearFormatting
    With Selection.Find.Font
        .Superscript = True
        .Subscript = False
    End With
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = ""
        .Replacement.Text = "<@NormalSuperscript>^&<@$p>"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
' Format Footnotes
If ActiveDocument.Footnotes.Count > 0 Then
ActiveDocument.StoryRanges(wdFootnotesStory).Select
    Selection.Find.Font.Italic = True
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = ""
        .Replacement.Text = "<I>^&<I>"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Selection.Find.ClearFormatting
    Selection.Find.Font.Bold = True
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = ""
        .Replacement.Text = "<B>^&<B>"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Selection.Find.ClearFormatting
    With Selection.Find.Font
        .Superscript = True
        .Subscript = False
    End With
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = ""
        .Replacement.Text = "<@NormalSuperscript>^&<@$p>"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Selection.Find.ClearFormatting
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = "<@NormalSuperscript>^f<@$p>"
        .Replacement.Text = "<\#9>^&<\#9>"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Selection.Find.ClearFormatting
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = "<\#9> "
        .Replacement.Text = "<\#9>"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    With Selection
        .Collapse Direction:=wdCollapseStart
        .TypeText Text:="@NoteHeading:ПРИМЕЧАНИЯ"
        .TypeParagraph
        .TypeText Text:="@Note:<@$p>"
    End With
On Error Resume Next
End If
' Format Endnotes
If ActiveDocument.Endnotes.Count > 0 Then
ActiveDocument.StoryRanges(wdEndnotesStory).Select
    Selection.Find.Font.Italic = True
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = ""
        .Replacement.Text = "<I>^&<I>"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Selection.Find.ClearFormatting
    Selection.Find.Font.Bold = True
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = ""
        .Replacement.Text = "<B>^&<B>"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Selection.Find.ClearFormatting
    With Selection.Find.Font
        .Superscript = True
        .Subscript = False
    End With
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = ""
        .Replacement.Text = "<@NormalSuperscript>^&<@$p>"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Selection.Find.ClearFormatting
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = "<@NormalSuperscript>^e<@$p>"
        .Replacement.Text = "<\#9>^&<\#9>"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = True
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    Selection.Find.ClearFormatting
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = "<\#9> "
        .Replacement.Text = "<\#9>"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    With Selection
        .Collapse Direction:=wdCollapseStart
        .TypeText Text:="@NoteHeading:ПРИМЕЧАНИЯ"
        .TypeParagraph
        .TypeText Text:="@Note:<@$p>"
    End With
On Error Resume Next
End If
End Sub
Sub SaveEdited()
    Dim sFName As String
    sFName = ActiveDocument.FullName
    If ActiveDocument.SaveFormat = wdFormatDocument And _
    Right(sFName, 4) = ".doc" Then
    ActiveDocument.SaveAs FileName:=Left(sFName, Len(sFName) - 4) & _
    "Edited.doc"
    End If
    ActiveDocument.Close
    If Application.Documents.Count = 0 Then
    Application.Quit
    End If
End Sub
Sub SaveAsTxt()
    Dim sFName As String
    sFName = ActiveDocument.FullName
    If ActiveDocument.SaveFormat = wdFormatDocument And _
    Right(sFName, 4) = ".doc" Then
    ActiveDocument.SaveAs FileName:=Left(sFName, Len(sFName) - 4) & _
    ".txt", FileFormat:=wdFormatText, Encoding:=1251
    End If
    ActiveDocument.Close
    If Application.Documents.Count = 0 Then
    Application.Quit
    End If
End Sub
Sub SaveAsTxtStay()
    Dim sFName As String
    sFName = ActiveDocument.FullName
    If ActiveDocument.SaveFormat = wdFormatDocument And _
    Right(sFName, 4) = ".doc" Then
    ActiveDocument.SaveAs FileName:=Left(sFName, Len(sFName) - 4) & _
    ".txt", FileFormat:=wdFormatText, Encoding:=1251
    End If
    ActiveDocument.Close
End Sub
Sub CleanupTag()
' Clean *.xtg files after editing with "hyphenRusUkr"
    Selection.Find.ClearFormatting
    Selection.Find.Replacement.ClearFormatting
    With Selection.Find
        .Text = "<\<>"
        .Replacement.Text = "<"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    With Selection.Find
        .Text = "<\>>"
        .Replacement.Text = ">"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
    With Selection.Find
        .Text = "<\@>"
        .Replacement.Text = "@"
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchWildcards = False
        .MatchSoundsLike = False
        .MatchAllWordForms = False
    End With
    Selection.Find.Execute Replace:=wdReplaceAll
ActiveDocument.Save
ActiveDocument.Close
If Application.Documents.Count = 0 Then
Application.Quit
End If
End Sub
Sub FindSpezial()
' Find characters of non-cyrillic codepage
    Selection.Find.ClearFormatting
    With Selection.Find
        .Text = "[" & ChrW(161) & ChrW(162) & ChrW(163) & ChrW(165) & ChrW( _
            168) & ChrW(170) & ChrW(175) & ChrW(178) & ChrW(179) & ChrW(180) & _
            ChrW(184) & ChrW(185) & ChrW(186) & ChrW(188) & ChrW(189) & ChrW(190 _
            ) & ChrW(191) & ChrW(192) & "-" & ChrW(974) & ChrW(1170) & "-" & _
            ChrW(8207) & ChrW(8206) & ChrW(8207) & ChrW(8206) & ChrW(8207) & _
            ChrW(8206) & ChrW(8207) & ChrW(8206) & ChrW(8207) & ChrW(8242) & _
            ChrW(8243) & ChrW(8219) & ChrW(8213) & ChrW(8252) & "-" & ChrW(8467) _
             & ChrW(8486) & "-" & ChrW(65276) & "]"
        .Replacement.Text = ""
        .Forward = True
        .Wrap = wdFindContinue
        .Format = False
        .MatchCase = False
        .MatchWholeWord = False
        .MatchAllWordForms = False
        .MatchSoundsLike = False
        .MatchWildcards = True
    End With
    Selection.Find.Execute
End Sub
Sub removestyle()
' Удаление неиспользуемых стилей в активном документе
Dim CStyles As Long, i As Integer, MasStyles() As String, Flag As Boolean
Application.ScreenUpdating = False
CStyles = ActiveDocument.Styles.Count
ReDim MasStyles(1 To CStyles)
For i = 1 To CStyles
  MasStyles(i) = ActiveDocument.Styles(i).NameLocal
Next
For i = 1 To CStyles
  With ActiveDocument.Content.Find
    .ClearFormatting
    Select Case MasStyles(i)
      Case "Заголовок", "Заголовок 1", "Заголовок 2", "Заголовок 3", _
           "Заголовок 4", "Заголовок 5", "Заголовок 6", "Заголовок 7", _
           "Заголовок 8", "Заголовок 9", _
           "Обычный", "Основной шрифт абзаца"
        Flag = False
      Case Else
        Flag = True
    End Select
    If ActiveDocument.Styles(MasStyles(i)).InUse = True And Flag = True Then
      .Style = MasStyles(i)
      StatusBar = "Поиск стиля: " & MasStyles(i)
      If .Execute(FindText:="", Wrap:=wdFindContinue) = False Then ActiveDocument.Styles(MasStyles(i)).Delete
    End If
  End With
Next
StatusBar = "Поиск завершен"
Application.ScreenUpdating = True
End Sub
