!define APPNAME "kLaunch"
!define VERSION "1.0.0.0"	; first two digits are version numbers, last digit is packet revision
; Version Information
VIProductVersion "${VERSION}"
VIAddVersionKey "ProductName" "${APPNAME}"
VIAddVersionKey "LegalCopyright" "Konstantin Karzanov"
VIAddVersionKey "FileDescription" "Application Launcher"
VIAddVersionKey "FileVersion" "${VERSION}"
; General Attributes
Name "${APPNAME}"
Caption "${APPNAME}"
OutFile "..\${APPNAME}.exe"
SilentInstall silent
AutoCloseWindow true
RequestExecutionLevel user
InstallDir "$EXEDIR"	; can be changed with /D= switch
; Installer Attributes
SetCompressor /SOLID /FINAL lzma
SetOverwrite ifnewer
; Plugins & Include
!addPluginDir ".\Plugins\FindProc"
!addPluginDir ".\Plugins\Textreplace"
!include "FileFunc.nsh"
!include "WordFunc.nsh"
!include ".\Include\PathFix.nsh"				; WordFunc.nsh, textreplace.dll required
!include ".\Include\ReadOptions.nsh"			; WordFunc.nsh required
!include ".\Include\LoopThroughValues.nsh"		; WordFunc.nsh required
!include ".\Include\BackupAndRestoreReg.nsh"	; WordFunc.nsh required
!include ".\Include\BackupAndRestoreFile.nsh"
!include ".\Include\BackupAndRestoreDir.nsh"
!include ".\Include\InitIni.nsh"
!include ".\Include\Errors.nsh"
; Variables
Var PARAMETERS	; Command line parameters
Var INIFILE		; File with current installer settings
Var INISECTION	; Section of program settings
Var EXECSTRING	; String to execute
Var EXECNAME	; Name of the program to execute
Var DEFARGS		; Command line parameters for the program to run in ini
Var APPARGS		; Command line parameters for the program to run on command line
Var DELIM		; Delimiter for LOCALREG, LOCALFILE & LOCALDIR lists
Var LOCALREG	; List of local registy keys to backup and restore
Var LOCALFILE	; List of local files to backup and restore
Var LOCALDIR	; List of local directories to backup and restore
Var LIVEREG		; Registry settings of the program to run
Var LIVEDIR		; Source directory with settings of the program to run witch will be copied in LIVETEMP
Var LIVETEMP 	; Distination directory with settings of the program to run (default: $TEMP\EXECNAME)
Var PFCONF		; Path Fix Configuration file in Live Settings Directory with search&replace values separated by delim
Var EDITOR		; String to execute in LiveSettingsRestore Function for aditional parameter editing
Var ERASE		; String to execute in LiveSettingsRemove Function for aditional (security) erasing
# .onInit
Function .onInit	; Checking the ability to run application. No files or registry changes on target system.
	Call AppInit	; attempt to define INI & EXEC
	Call IniRead	; if ini defined, read options and assign/overwrite user variables
	Call CmdRead	; if cmd defined, read options and assign/overwrite user variables
	Call VarCheck	; if delim & lstmp not defined assign default values
	Call ExecBuild	; if args defined, rebuild EXECSTRING
FunctionEnd
Function AppInit
	${GetParameters} $PARAMETERS
	${GetBaseName} "$EXEFILE" $R1
	${InitIni} "$PARAMETERS" "$R1" "app" $R0 $INIFILE $INISECTION	; _PARAMETERS _BASENAME _ENTRYNAME _RESULTSTRING _RESULTINIFILE _RESULTINISECTION
	IfErrors CmdCheck
		Call DefineExec	; use $R0
		Return
	CmdCheck:
	${GetOptions} "$PARAMETERS" "/app=" $R0	; _PARAMETERS _OPTION _RESULT
	IfErrors Usage
		Call DefineExec	; use $R0
		StrCpy $INISECTION "$EXECNAME"
		Return
	Usage:
	${FatalError} "Usage: $EXEFILE your_app"
FunctionEnd
Function DefineExec	; $R0 = string
	StrCmp "'$R0'" "''" AppBlank
		${ExpandEnvStrPlus} "$R0" "$R0"		; _STRING _RESULT
		StrCpy $EXECSTRING '$R0'			; SearchPath $EXECSTRING $R0 makes impossible to run app from temp
		${GetFileName} "$EXECSTRING" $R0	; _PATHSTRING _RESULT
		${GetBaseName} $R0 "$EXECNAME"		; _FILESTRING _RESULT
		Return
	AppBlank:
	${FatalError} "app parameter is not specified properly"
FunctionEnd
Function IniRead
	StrCmp "'$INIFILE'" "''" Done
		${ReadAndExpandIniEntry} "$INIFILE" "$INISECTION" "args" $DEFARGS
		${ReadAndExpandIniEntry} "$INIFILE" "$INISECTION" "delim" $DELIM
		${ReadAndExpandIniEntry} "$INIFILE" "$INISECTION" "mreg" $LOCALREG
		${ReadAndExpandIniEntry} "$INIFILE" "$INISECTION" "mfile" $LOCALFILE
		${ReadAndExpandIniEntry} "$INIFILE" "$INISECTION" "mdir" $LOCALDIR
		${ReadAndExpandIniEntry} "$INIFILE" "$INISECTION" "sreg" $LIVEREG
		${ReadAndExpandIniEntry} "$INIFILE" "$INISECTION" "sdir" $LIVEDIR
		${ReadAndExpandIniEntry} "$INIFILE" "$INISECTION" "tmp" $LIVETEMP
		${ReadAndExpandIniEntry} "$INIFILE" "$INISECTION" "pfc" $PFCONF
		${ReadAndExpandIniEntry} "$INIFILE" "$INISECTION" "sed" $EDITOR
		${ReadAndExpandIniEntry} "$INIFILE" "$INISECTION" "ser" $ERASE
	Done:
FunctionEnd
Function CmdRead
	StrCmp "'$PARAMETERS'" "''" Done
		${ExpandEnvStrPlus} "$PARAMETERS" $PARAMETERS
		${ReadOption} "$PARAMETERS" "/args=" $APPARGS
		${ReadOption} "$PARAMETERS" "/delim=" $DELIM
		${ReadOption} "$PARAMETERS" "/mreg=" $LOCALREG
		${ReadOption} "$PARAMETERS" "/mfile=" $LOCALFILE
		${ReadOption} "$PARAMETERS" "/mdir=" $LOCALDIR
		${ReadOption} "$PARAMETERS" "/sreg=" $LIVEREG
		${ReadOption} "$PARAMETERS" "/sdir=" $LIVEDIR
		${ReadOption} "$PARAMETERS" "/tmp=" $LIVETEMP
		${ReadOption} "$PARAMETERS" "/pfc=" $PFCONF
		${ReadOption} "$PARAMETERS" "/sed=" $EDITOR
		${ReadOption} "$PARAMETERS" "/ser=" $ERASE
	Done:
FunctionEnd
Function VarCheck
	StrCmp "'$DELIM'" "''" +1 +2
		StrCpy $DELIM "||"
	StrCmp "'$PFCONF'" "''" +1 +2
		StrCpy $PFCONF "pathfix.conf"
	StrCmp "'$LIVETEMP'" "''" +1 +2
		Call DefineTemp
FunctionEnd
Function DefineTemp
	StrCmp "$ERASE" "false" +1 +3
		StrCpy $LIVETEMP "$DOCUMENTS\$EXECNAME"
		Return
	StrCpy $LIVETEMP "$TEMP\$EXECNAME"
FunctionEnd
Function ExecBuild
	StrCpy $EXECSTRING '"$EXECSTRING"'
	StrCmp "'$DEFARGS'" "''" +2
		StrCpy $EXECSTRING '$EXECSTRING $DEFARGS'
	StrCmp "'$APPARGS'" "''" +2
		StrCpy $EXECSTRING '$EXECSTRING $APPARGS'
FunctionEnd
# main
Section	; Backup local registry & files. Restore live settings. Run program
	FindProcDLL::FindProc "$EXECNAME.exe"                 
	StrCmp "$R0" "1" ExecQuit
		StrCmp "$ERASE" "false" RestoreExecQuit
			Call LocalSettingsBackup
			Call LiveSettingsRestore
			SetOutPath "$LIVETEMP"	; Some programs attempt to write in it
			ExecWait $EXECSTRING
			Return
		RestoreExecQuit:
		Call LiveSettingsRestore
	ExecQuit:						; to prevent unexpected results no files or registry changes on target system
	SetOutPath $LIVETEMP			; Some programs attempt to write in it
	Exec $EXECSTRING
	Quit
SectionEnd
Function LocalSettingsBackup
	StrCmp "'$LOCALREG'" "''" NoLocalReg
		${LoopThroughValues} "$LOCALREG" "$DELIM" "BackupReg"	; _VALUES _DELIMITER _FUNCTION
	NoLocalReg:
	StrCmp "'$LOCALFILE'" "''" NoLocalFile
		${LoopThroughValues} "$LOCALFILE" "$DELIM" "BackupFile"	; _VALUES _DELIMITER _FUNCTION
	NoLocalFile:
	StrCmp "'$LOCALDIR'" "''" NoLocalDir
		${LoopThroughValues} "$LOCALDIR" "$DELIM" "BackupDir"	; _VALUES _DELIMITER _FUNCTION
	NoLocalDir:
FunctionEnd
Function LiveSettingsRestore
	IfFileExists "$LIVETEMP" LiveTempExists
		SearchPath $LIVEDIR "$LIVEDIR"	; result(full path) path_or_file (search in: $EXEDIR, $WINDIR, $SYSDIR)
		IfErrors NoLiveDir
			CreateDirectory "$LIVETEMP"
			CopyFiles /SILENT "$LIVEDIR\*.*" "$LIVETEMP"
			${Locate} "$LIVETEMP" "/L=F" "FixAttrib"
	LiveTempExists:
	${PathFix} "$LIVETEMP\$PFCONF" "$DELIM" "ExpandEnvStrPlus"
	NoLiveDir:
	SearchPath "$LIVEREG" "$LIVEREG"
	IfErrors NoLiveReg
		nsExec::Exec '"$WINDIR\system32\reg.exe" import "$LIVEREG"'
	NoLiveReg:
	StrCmp "'$EDITOR'" "''" NoEditor
		ExecWait '$EDITOR'
	NoEditor:
FunctionEnd
Function FixAttrib	; $R9 = file
	SetFileAttributes $R9 0
	Push $0
FunctionEnd
# .onInstSuccess
Function .onInstSuccess	; Remove live settings. Restore local registry & files
	Call LiveSettingsRemove
	Call LocalSettingsRestore
FunctionEnd
Function LiveSettingsRemove
	SetOutPath "$PROFILE"	; We have OUTDIR=$LIVETEMP in Section "Main"
	StrCmp "'$ERASE'" "''" Remove
		StrCmp "$ERASE" "true" Remove
			ExecWait '$ERASE'
	Remove:
	IfFileExists "$LIVETEMP" 0 +2
		RMDir /r "$LIVETEMP\"
FunctionEnd
Function LocalSettingsRestore
	StrCmp "'$LOCALDIR'" "''" NoLocalDir
		${LoopThroughValues} "$LOCALDIR" "$DELIM" "RestoreDir"		; _VALUES _DELIMITER _FUNCTION
	NoLocalDir:
	StrCmp "'$LOCALFILE'" "''" NoLocalFile
		${LoopThroughValues} "$LOCALFILE" "$DELIM" "RestoreFile"	; _VALUES _DELIMITER _FUNCTION
	NoLocalFile:
	StrCmp "'$LOCALREG'" "''" NoLocalReg
		${LoopThroughValues} "$LOCALREG" "$DELIM" "RestoreReg"		; _VALUES _DELIMITER _FUNCTION
	NoLocalReg:
FunctionEnd
