!define InitIni '!insertmacro InitIni'
!macro InitIni _PARAMETERS _BASENAME _ENTRYNAME _RESULTSTRING _RESULTINIFILE _RESULTINISECTION
	Push ${_PARAMETERS}
	Push ${_BASENAME}
	Push ${_ENTRYNAME}
	Call InitIni
	Pop ${_RESULTINISECTION}
	Pop ${_RESULTINIFILE}
	Pop ${_RESULTSTRING}
!macroend
; FileFunc.nsh required
Function InitIni
	Exch $2	; _ENTRYNAME
	Exch
	Exch $1	; _BASENAME
	Exch
	Exch 2
	Exch $0	; _PARAMETERS
	Exch 2
	Push $3	; _RESULTSTRING
	Push $4	; _RESULTINIFILE
	Push $5	; _RESULTINISECTION
	StrCpy $3 ""
	StrCpy $4 ""
	StrCpy $5 ""
	ClearErrors
	SearchPath $4 "$0.ini"				; _PARAMETERS.ini
	IfErrors DefIni						; try _BASENAME.ini
		ReadINIStr "$3" "$4" "$1" "$2"	; section _BASENAME
		IfErrors InitIni_error			; if we have _PARAMETERS.ini without _ENTRYNAME or _BASENAME section
			StrCpy $5 "$1"
			Goto InitIni_end
	DefIni:
	SearchPath $4 "$1.ini"				; _BASENAME.ini
	IfErrors InitIni_error				; no ini found
		ReadINIStr "$3" "$4" "$0" "$2"	; section _PARAMETERS
		IfErrors NoCmd					; if we have _BASENAME.ini without _ENTRYNAME or _PARAMETERS section
			StrCpy $5 "$0"
			Goto InitIni_end
		NoCmd:
		ReadINIStr "$3" "$4" "$1" "$2"	; section _BASENAME
		IfErrors InitIni_error			; if we have _BASENAME.ini without _ENTRYNAME or _BASENAME section
			StrCpy $5 "$1"
			Goto InitIni_end
	InitIni_error:
	SetErrors
	InitIni_end:
	Exch 3
	Pop $2
	Exch 3
	Pop $1
	Exch 3
	Pop $0
	Exch $5
	Exch
	Exch $4
	Exch
	Exch 2
	Exch $3
	Exch 2
FunctionEnd