import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;

import com.google.gdata.client.contacts.ContactsService;
import com.google.gdata.data.contacts.ContactFeed;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;

public class GDBakContacts extends GDBakFeed implements GDBak {

	public GDBakContacts(String url, File file) {
		super(new ContactsService(GDBakMain.APPNAME), url, file);
	}

	@Override
	public void backup() throws MalformedURLException, IOException, ServiceException {
		ContactFeed contactFeed = getFeed(ContactFeed.class);
		write(contactFeed, contactFeed.getEntries().get(0).getUpdated());
	}

	@Override
	public void connect(String email, String passwd) throws AuthenticationException {
		setUserCredentials(email, passwd);
	}

}
