import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;

import com.google.gdata.client.calendar.CalendarService;
import com.google.gdata.data.calendar.CalendarFeed;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;

public class GDBakCalendar extends GDBakFeed implements GDBak {

	public GDBakCalendar(String url, File file) {
		super(new CalendarService(GDBakMain.APPNAME), url, file);
	}

	@Override
	public void backup() throws MalformedURLException, IOException, ServiceException {
		CalendarFeed calendarFeed = getFeed(CalendarFeed.class);
		write(calendarFeed, calendarFeed.getUpdated());
	}

	@Override
	public void connect(String email, String passwd) throws AuthenticationException {
		setUserCredentials(email, passwd);
	}

}
