/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class GDBakMain {
    public static final String APPNAME = "konskar-gdbak-1.0.0";
    private static final Logger logger = Logger.getLogger(GDBakMain.class.getName());
    private final Properties props = new Properties();
    private final List<GDBak> list = new ArrayList<GDBak>(1);
    private String bakdir;

    public static void main(String[] args) {
        logger.info("Google Data backup start");
        GDBakMain gdbak = new GDBakMain();
        gdbak.loadProperties();
        gdbak.fillList();
        gdbak.connect(args.length >= 1 ? args[0] : null, args.length == 2 ? args[1] : null);
        gdbak.backup();
        logger.info("Google Data backup complete");
    }

    private void backup() {
        for (GDBak gdbak : this.list) {
            try {
                gdbak.backup();
            }
            catch (Exception e) {
                logger.severe(e.getMessage());
                logger.config(this.getStackTrace(e));
            }
        }
    }

    private void connect(String email, String passwd) {
        while (true) {
            if (email == null) {
                email = System.console().readLine("Enter your email [your_email@gmail.com]: ", new Object[0]);
            }
            if (passwd == null) {
                passwd = new String(System.console().readPassword("Enter your password [your_password]: ", new Object[0]));
            }
            try {
                for (GDBak gdbak : this.list) {
                    gdbak.connect(email, passwd);
                }
                logger.info("Authentication succeeded");
                return;
            }
            catch (Exception e) {
                email = null;
                passwd = null;
                logger.severe(e.getMessage());
                logger.config(this.getStackTrace(e));
                continue;
            }
            break;
        }
    }

    private String getStackTrace(Exception e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(e.getClass().getCanonicalName()).append(": ");
        buffer.append(e.getMessage()).append("\n");
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste = stackTraceElementArray[n2];
            buffer.append("\tat ").append(ste.getClassName()).append(".");
            buffer.append(ste.getMethodName()).append(" (");
            buffer.append(ste.getFileName()).append(":");
            buffer.append(ste.getLineNumber()).append(")\n");
            ++n2;
        }
        return buffer.toString();
    }

    private void fillList() {
        if (Boolean.valueOf(this.getProperty("gdbak.mail")).booleanValue()) {
            this.list.add(new GDBakMail(this.props, this.getPath("gdbak.mail.dir")));
        }
        if (Boolean.valueOf(this.getProperty("gdbak.docs")).booleanValue()) {
            this.list.add(new GDBakDocs(this.props, this.getPath("gdbak.docs.dir")));
        }
        if (Boolean.valueOf(this.getProperty("gdbak.calendar")).booleanValue()) {
            this.list.add(new GDBakCalendar(this.getProperty("gdbak.calendar.url"), this.getPath("gdbak.calendar.file")));
        }
        if (Boolean.valueOf(this.getProperty("gdbak.contacts")).booleanValue()) {
            this.list.add(new GDBakContacts(this.getProperty("gdbak.contacts.url"), this.getPath("gdbak.contacts.file")));
        }
        if (Boolean.valueOf(this.getProperty("gdbak.reader")).booleanValue()) {
            this.list.add(new GDBakHttp(this.props, this.getProperty("gdbak.reader.url"), this.getPath("gdbak.reader.file")));
        }
        if (Boolean.valueOf(this.getProperty("gdbak.bookmarks")).booleanValue()) {
            this.list.add(new GDBakHttp(this.props, this.getProperty("gdbak.bookmarks.url"), this.getPath("gdbak.bookmarks.file")));
        }
        if (Boolean.valueOf(this.getProperty("gdbak.igoogle")).booleanValue()) {
            this.list.add(new GDBakHttp(this.props, this.getProperty("gdbak.igoogle.url"), this.getPath("gdbak.igoogle.file")));
        }
        if (this.list.isEmpty()) {
            logger.info("No Backups have been selected");
            System.exit(0);
        }
    }

    private void loadProperties() {
        try {
            this.props.load(GDBakMain.class.getResourceAsStream("gdbak.properties"));
            this.props.putAll((Map<?, ?>)System.getProperties());
            this.props.load(new FileInputStream(this.props.getProperty("gdbak.props", "gdbak.properties")));
        }
        catch (IOException e) {
            logger.info(e.getMessage());
        }
        this.bakdir = this.props.getProperty("gdbak.dir", this.props.getProperty("user.dir"));
    }

    private File getPath(String key) {
        return new File(this.bakdir, this.getProperty(key)).getAbsoluteFile();
    }

    private String getProperty(String key) {
        return this.props.getProperty(key);
    }
}

