/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;

public class GDBakMail
implements GDBak {
    private static final Logger logger = Logger.getLogger(GDBakMail.class.getName());
    private Store store;
    private Properties props;
    private File parent;

    public GDBakMail(Properties props, File parent) {
        this.props = props;
        this.parent = parent;
    }

    @Override
    public void backup() throws MessagingException, IOException {
        this.parent.mkdirs();
        String label = this.props.getProperty("gdbak.mail.label");
        if (label.equalsIgnoreCase("all")) {
            Folder[] folderArray = this.store.getDefaultFolder().list();
            int n = folderArray.length;
            int n2 = 0;
            while (n2 < n) {
                Folder folder = folderArray[n2];
                this.backup(folder);
                ++n2;
            }
        } else {
            this.backup(this.store.getFolder(label));
        }
        this.store.close();
        logger.info("Google Mail backup complete");
    }

    private void backup(Folder folder) throws MessagingException, IOException {
        folder.open(1);
        this.backup(folder.getMessages());
        folder.close(true);
    }

    private void backup(Message[] messages) throws MessagingException, IOException {
        SimpleDateFormat sdf = new SimpleDateFormat(this.props.getProperty("gdbak.mail.name"));
        String ext = this.props.getProperty("gdbak.mail.ext");
        Message[] messageArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            Message message = messageArray[n2];
            File file = new File(this.parent, String.valueOf(sdf.format(message.getSentDate())) + "_" + message.getMessageNumber() + "." + ext);
            if (!file.exists()) {
                this.write(message, file);
            }
            ++n2;
        }
    }

    private void write(Message message, File file) throws IOException, MessagingException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            message.writeTo((OutputStream)fos);
            logger.config("write to " + file.toString());
        }
        finally {
            if (fos != null) {
                fos.flush();
                fos.close();
            }
        }
    }

    @Override
    public void connect(String email, String passwd) throws MessagingException {
        Session session = Session.getDefaultInstance((Properties)this.props);
        this.store = session.getStore(this.props.getProperty("mail.store.protocol"));
        this.store.connect(this.props.getProperty("gdbak.mail.host"), email, passwd);
    }
}

