/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class GDBakHttp
implements GDBak {
    private static final Logger logger = Logger.getLogger(GDBakHttp.class.getName());
    private static final DefaultHttpClient httpClient = new DefaultHttpClient();
    private static boolean authentificationDone;
    private Properties props;
    private String url;
    private File file;

    public GDBakHttp(Properties props, String url, File file) {
        this.props = props;
        this.url = url;
        this.file = file;
    }

    @Override
    public void backup() throws ClientProtocolException, IOException {
        HttpGet get = new HttpGet(this.url);
        HttpResponse response = httpClient.execute((HttpUriRequest)get);
        this.write(response, this.file);
    }

    private void write(HttpResponse httpResponse, File file) throws IOException {
        file.getParentFile().mkdirs();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            httpResponse.getEntity().writeTo((OutputStream)fos);
            logger.config("write to " + file.toString());
        }
        finally {
            if (fos != null) {
                fos.flush();
                fos.close();
            }
        }
    }

    @Override
    public void connect(String email, String passwd) throws ClientProtocolException, IOException {
        if (!authentificationDone) {
            String galx = this.serviceLogin(this.props.getProperty("gdbak.http.sl.url"));
            this.serviceLoginAuth(this.props.getProperty("gdbak.http.sla.url"), email, passwd, galx);
            authentificationDone = true;
        }
    }

    private void serviceLoginAuth(String url, String email, String passwd, String galx) throws ClientProtocolException, IOException {
        HttpPost post = new HttpPost(url);
        ArrayList<BasicNameValuePair> nameValuePair = new ArrayList<BasicNameValuePair>(1);
        nameValuePair.add(new BasicNameValuePair("Email", email));
        nameValuePair.add(new BasicNameValuePair("Passwd", passwd));
        nameValuePair.add(new BasicNameValuePair("GALX", galx));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePair));
        HttpResponse response = httpClient.execute((HttpUriRequest)post);
        response.getEntity().consumeContent();
    }

    private String serviceLogin(String url) throws ClientProtocolException, IOException {
        HttpGet get = new HttpGet(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)get);
        response.getEntity().consumeContent();
        for (Cookie cookie : httpClient.getCookieStore().getCookies()) {
            if (!cookie.getName().equalsIgnoreCase("GALX")) continue;
            return cookie.getValue();
        }
        throw new IOException("Required cookie is not present");
    }
}

