/*
 * Decompiled with CFR 0.152.
 */
import com.google.gdata.client.GoogleService;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.IFeed;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

public class GDBakFeed {
    private static final Logger logger = Logger.getLogger(GDBakFeed.class.getName());
    private GoogleService service;
    private String url;
    private File file;

    public GDBakFeed(GoogleService service, String url, File file) {
        this.service = service;
        this.url = url;
        this.file = file;
    }

    public void write(BaseFeed<?, ?> feed, DateTime updated) throws IOException {
        if (!this.file.exists() || updated.getValue() > this.file.lastModified()) {
            this.file.getParentFile().mkdirs();
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF8");
                feed.generateAtom(new XmlWriter((Writer)writer, "UTF-8"), new ExtensionProfile());
                logger.config("write to " + this.file.toString());
            }
            finally {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
        }
    }

    public <F extends IFeed> F getFeed(Class<F> feedClass) throws MalformedURLException, IOException, ServiceException {
        return (F)this.service.getFeed(new URL(this.url), feedClass);
    }

    public void setUserCredentials(String email, String passwd) throws AuthenticationException {
        this.service.setUserCredentials(email, passwd);
    }
}

