/*
 * Decompiled with CFR 0.152.
 */
import com.google.gdata.client.GoogleAuthTokenFactory;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.docs.DocsService;
import com.google.gdata.data.MediaContent;
import com.google.gdata.data.docs.DocumentListEntry;
import com.google.gdata.data.docs.DocumentListFeed;
import com.google.gdata.data.media.IMediaContent;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class GDBakDocs
implements GDBak {
    private static final Logger logger = Logger.getLogger(GDBakDocs.class.getName());
    private DocsService docsService = new DocsService("konskar-gdbak-1.0.0");
    private GoogleService googleService = new GoogleService("wise", "konskar-gdbak-1.0.0");
    private Properties props;
    private File parent;

    public GDBakDocs(Properties props, File parent) {
        this.props = props;
        this.parent = parent;
    }

    @Override
    public void backup() throws IOException, ServiceException {
        URL url = new URL(this.props.getProperty("gdbak.docs.url"));
        DocumentListFeed feed = (DocumentListFeed)this.docsService.getFeed(url, DocumentListFeed.class);
        this.backup(feed.getEntries());
        logger.info("Google Docs backup complete");
    }

    private void backup(List<DocumentListEntry> entries) throws IOException, ServiceException {
        this.parent.mkdirs();
        String docExt = this.props.getProperty("gdbak.document.ext");
        String preExt = this.props.getProperty("gdbak.presentation.ext");
        String draExt = this.props.getProperty("gdbak.drawing.ext");
        String sprExt = this.props.getProperty("gdbak.spreadsheet.ext");
        for (DocumentListEntry entry : entries) {
            if (entry.getType().equalsIgnoreCase("document")) {
                this.write(entry, docExt);
                continue;
            }
            if (entry.getType().equalsIgnoreCase("presentation")) {
                this.write(entry, preExt);
                continue;
            }
            if (entry.getType().equalsIgnoreCase("drawing")) {
                this.write(entry, draExt);
                continue;
            }
            if (!entry.getType().equalsIgnoreCase("spreadsheet")) continue;
            GoogleAuthTokenFactory.UserToken docsToken = (GoogleAuthTokenFactory.UserToken)this.docsService.getAuthTokenFactory().getAuthToken();
            GoogleAuthTokenFactory.UserToken spreadsheetsToken = (GoogleAuthTokenFactory.UserToken)this.googleService.getAuthTokenFactory().getAuthToken();
            this.docsService.setUserToken(spreadsheetsToken.getValue());
            this.write(entry, sprExt);
            this.docsService.setUserToken(docsToken.getValue());
        }
    }

    private void write(DocumentListEntry entry, String ext) throws IOException, ServiceException {
        File file = new File(this.parent, String.valueOf(entry.getTitle().getPlainText()) + "." + ext);
        if (!file.exists() || entry.getUpdated().getValue() > file.lastModified()) {
            String exportUrl = String.valueOf(((MediaContent)entry.getContent()).getUri()) + "&exportFormat=" + ext;
            MediaContent mc = new MediaContent();
            mc.setUri(exportUrl);
            MediaSource ms = this.docsService.getMedia((IMediaContent)mc);
            this.write(ms.getInputStream(), file);
        }
    }

    private void write(InputStream inputStream, File file) throws IOException {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int count;
            bis = new BufferedInputStream(inputStream);
            bos = new BufferedOutputStream(new FileOutputStream(file), 1024);
            byte[] data = new byte[1024];
            while ((count = bis.read(data)) != -1) {
                bos.write(data, 0, count);
            }
            logger.config("write to " + file.toString());
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.flush();
                bos.close();
            }
        }
    }

    @Override
    public void connect(String email, String passwd) throws AuthenticationException {
        this.docsService.setUserCredentials(email, passwd);
        this.googleService.setUserCredentials(email, passwd);
    }
}

