/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeSelectionModel;
import main.Resources;

public class PanelTree
extends JPanel {
    private static final long serialVersionUID = 871598368878726765L;
    private JPanel filterPanel = new JPanel();
    private JTree tree = new JTree();
    private JTextPane infoPane = new JTextPane();

    public PanelTree(String keyInfoText, boolean useCheckbox) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.add((Component)this.getFilterPanel(), "North");
        this.add((Component)this.getTreePane(), "Center");
        this.add((Component)this.getInfoPane(), "South");
        this.setInfo(Resources.getString(keyInfoText));
        if (useCheckbox) {
            this.addCheckBox();
        }
    }

    private JPanel getFilterPanel() {
        BoxLayout layout = new BoxLayout(this.filterPanel, 0);
        this.filterPanel.setLayout(layout);
        this.filterPanel.setPreferredSize(new Dimension(130, 30));
        return this.filterPanel;
    }

    private JScrollPane getTreePane() {
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        treeScrollPane.setPreferredSize(new Dimension(130, 140));
        return treeScrollPane;
    }

    private JScrollPane getInfoPane() {
        this.infoPane.setEditable(false);
        JScrollPane panel = new JScrollPane(this.infoPane);
        panel.setPreferredSize(new Dimension(130, 140));
        return panel;
    }

    private void addCheckBox() {
        JCheckBox cBox = new JCheckBox(Resources.getString("Szen.lwp_filter"));
        this.filterPanel.add(cBox);
    }

    public void setInfo(String info) {
        this.infoPane.setText(info);
    }

    public void setModels(TreeModel newModel, TreeSelectionModel selectionModel) {
        this.tree.setModel(newModel);
        this.tree.setSelectionModel(selectionModel);
    }
}

