/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import main.Resources;

public class MenuLaf
extends JMenu {
    private static final long serialVersionUID = -7224147425212104092L;
    private Container parent = null;

    public MenuLaf(Container mainContainer) {
        super(Resources.getString("LafMenu.laf_label"));
        this.parent = mainContainer;
        this.setMnemonic(Resources.getMnemonic("LafMenu.laf_mnemonic"));
        this.setMenu();
    }

    private void setMenu() {
        ButtonGroup rg = new ButtonGroup();
        UIManager.LookAndFeelInfo[] installedLookAndFeels = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < installedLookAndFeels.length) {
            String lafName = installedLookAndFeels[i].getName();
            String lafClassName = installedLookAndFeels[i].getClassName();
            if (this.isAvailableLaf(lafClassName)) {
                JRadioButtonMenuItem mi = this.createLafMenuItem(lafName, lafClassName);
                this.add(mi);
                rg.add(mi);
            }
            ++i;
        }
    }

    private JRadioButtonMenuItem createLafMenuItem(String lafName, String lafClassName) {
        JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem(lafName);
        rbmi.setMnemonic(lafName.charAt(0));
        this.setLafMenuItem(rbmi, lafClassName);
        return rbmi;
    }

    private JRadioButtonMenuItem setLafMenuItem(JRadioButtonMenuItem rbmi, final String lafClassName) {
        String curlaf = UIManager.getLookAndFeel().getClass().getName();
        rbmi.setSelected(lafClassName.equals(curlaf));
        rbmi.setActionCommand("lafChanged");
        rbmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuLaf.this.setLaf(lafClassName);
            }
        });
        return rbmi;
    }

    private boolean isAvailableLaf(String lafClassName) {
        try {
            LookAndFeel laf = (LookAndFeel)Class.forName(lafClassName).newInstance();
            return laf.isSupportedLookAndFeel();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void setLaf(String lafClassName) {
        try {
            UIManager.setLookAndFeel(lafClassName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.updateComponentTreeUI(this.parent);
    }
}

