/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeSelectionModel;
import main.Resources;
import view.Constraints;
import view.MenuLaf;
import view.MenuProgram;
import view.PanelCombo;
import view.PanelDimensionen;
import view.PanelFutterzeit;
import view.PanelLebewesen;
import view.PanelSpinners;

public class Aqua3EditorViewRoot {
    private Container parent;
    private Container contentPane;
    private PanelLebewesen lebewesenPanel;
    private PanelCombo szenarienPanel;
    private PanelCombo aquariumPanel;
    private PanelSpinners tempPanel;
    private PanelSpinners phPanel;
    private PanelSpinners lichtPanel;
    private PanelFutterzeit futterzeitPanel;
    private PanelDimensionen dimensionenPanel;
    private MenuProgram menuProgram;
    private MenuLaf menuLaf;

    public Aqua3EditorViewRoot(JFrame frame) {
        this.parent = frame;
        this.contentPane = frame.getContentPane();
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        this.init(menuBar);
    }

    public Aqua3EditorViewRoot(JApplet applet) {
        this.parent = applet;
        this.contentPane = applet.getContentPane();
        JMenuBar menuBar = new JMenuBar();
        applet.setJMenuBar(menuBar);
        this.init(menuBar);
    }

    private void init(JMenuBar menuBar) {
        this.initMenu(menuBar);
        this.initContent();
    }

    private void initMenu(JMenuBar mb) {
        if (this.parent instanceof JFrame) {
            this.menuProgram = new MenuProgram(this.parent);
            mb.add(this.menuProgram);
        }
        this.menuLaf = new MenuLaf(this.parent);
        mb.add(this.menuLaf);
    }

    private void initContent() {
        this.szenarienPanel = new PanelCombo();
        this.aquariumPanel = new PanelCombo("Szen.aqp_border");
        this.tempPanel = new PanelSpinners("Szen.tempp_border", "Szen.tempp_minLabel", "Szen.tempp_maxLabel");
        this.phPanel = new PanelSpinners("Szen.php_border", "Szen.php_minLabel", "Szen.php_maxLabel");
        this.lichtPanel = new PanelSpinners("Szen.lichtp_border", "Szen.lichtp_einLabel", "Szen.lichtp_ausLabel");
        this.futterzeitPanel = new PanelFutterzeit();
        this.lebewesenPanel = new PanelLebewesen();
        this.dimensionenPanel = new PanelDimensionen();
        JPanel northPanel = new JPanel(new GridBagLayout());
        northPanel.add((Component)this.szenarienPanel, new Constraints(0, 0, 6, 1).setWeight(1.0, 0.0).setAnchor(18).setFill(2).setInsets(5, 5, 0, 5));
        northPanel.add((Component)this.aquariumPanel, new Constraints(0, 1, 6, 1).setWeight(1.0, 0.0).setAnchor(17).setFill(2));
        northPanel.add((Component)this.tempPanel, new Constraints(0, 2, 2, 2).setWeight(1.0, 0.0).setAnchor(17).setFill(2));
        northPanel.add((Component)this.phPanel, new Constraints(2, 2, 2, 2).setWeight(1.0, 0.0).setAnchor(17).setFill(2));
        northPanel.add((Component)this.lichtPanel, new Constraints(4, 2, 2, 2).setWeight(1.0, 0.0).setAnchor(17).setFill(2));
        northPanel.add((Component)this.futterzeitPanel, new Constraints(6, 1, 4, 3).setWeight(1.0, 0.0).setAnchor(17).setFill(1));
        this.contentPane.add((Component)northPanel, "North");
        this.contentPane.add((Component)this.lebewesenPanel, "Center");
    }

    public void setSzenarienModels(ComboBoxModel aModel, ComboBoxEditor anEditor) {
        this.szenarienPanel.setModels(aModel, anEditor);
    }

    public void setAquariumModels(ComboBoxModel aModel, ComboBoxEditor anEditor) {
        this.aquariumPanel.setModels(aModel, anEditor);
    }

    public void setDbLebewesenModels(TreeModel newModel, TreeSelectionModel selectionModel) {
        this.lebewesenPanel.setDbLebewesenModels(newModel, selectionModel);
    }

    public void setTempModels(SpinnerModel[] models) {
        this.tempPanel.setModels(models);
    }

    public void setPhModels(SpinnerModel[] models) {
        this.phPanel.setModels(models);
    }

    public void setLichtModels(SpinnerModel[] models, String dateEditorPattern) {
        this.lichtPanel.setModels(models, dateEditorPattern);
    }

    public void setFutterzeitModels(ListModel listModel, ListSelectionModel selectionModel, SpinnerDateModel spinnerDateModel, String dateEditorPattern) {
        this.futterzeitPanel.setModels(listModel, selectionModel, spinnerDateModel, dateEditorPattern);
    }

    public void setSzLebewesenModels(TreeModel newModel, TreeSelectionModel selectionModel) {
        this.lebewesenPanel.setSzLebewesenModels(newModel, selectionModel);
    }

    public void setDimensionenModels(SpinnerModel[] models) {
        this.dimensionenPanel.setModels(models);
    }

    public void addMenuProgramItem(Action a) {
        this.menuProgram.addItem(a);
    }

    public void setSzenarienActions(Action[] actions) {
        this.szenarienPanel.setActions(actions);
    }

    public void setAquariumActions(Action[] actions) {
        this.aquariumPanel.setActions(actions);
    }

    public void setFutterzeitActions(Action[] actions) {
        this.futterzeitPanel.setActions(actions);
    }

    public void setLebewesenActions(Action[] actions) {
        this.lebewesenPanel.setActions(actions);
    }

    public void setDimensionenActions(Action[] actions) {
        this.dimensionenPanel.setActions(actions);
    }

    public void showDimensionenDialog() {
        this.dimensionenPanel.showDialog(this.parent);
    }

    public void hideDimensionenDialog() {
        this.dimensionenPanel.hideDialog();
    }

    public int getLebewesenMenge(String name, int initialValue) {
        String value = JOptionPane.showInputDialog(String.valueOf(Resources.getString("Szen.lwp_howMuch")) + " " + name + "?", (Object)initialValue);
        if (value == null || value.length() == 0) {
            return 0;
        }
        return Integer.parseInt(value);
    }
}

