/*
 * Decompiled with CFR 0.152.
 */
package model;

import dao.SzenarienDao;
import domain.Dimensionen;
import domain.Szenarien;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import model.DimensionenModel;
import model.FutterzeitModel;
import model.SzenarienLebewesenModel;
import model.SzenarienNameEditor;

public class SzenarienModel
extends AbstractListModel
implements MutableComboBoxModel,
Serializable {
    private static final long serialVersionUID = -7888833300976707376L;
    private SzenarienDao dao;
    private List<Szenarien> szenarien;
    private Object selectedItem;
    private ComboBoxModel dimensionenModel;
    private FutterzeitModel futterzeitModel;
    private SzenarienLebewesenModel szLebewesenModel;
    private ComboBoxEditor nameEditor = new SzenarienNameEditor();
    private final SpinnerModel[] tempWerteModels = new SpinnerModel[]{new SpinnerNumberModel(22.0, 15.0, 35.0, 0.5), new SpinnerNumberModel(28.0, 15.0, 35.0, 0.5)};
    private final SpinnerModel[] phWerteModels = new SpinnerModel[]{new SpinnerNumberModel(5.0, 0.0, 10.0, 0.5), new SpinnerNumberModel(8.0, 0.0, 10.0, 0.5)};
    private final SpinnerModel[] lichtWerteModels = new SpinnerModel[]{new SpinnerDateModel(new Date(), null, null, 11), new SpinnerDateModel(new Date(), null, null, 11)};
    public static final String PATTERN = "HH:mm";

    public SzenarienModel(SzenarienDao dao) {
        this.dao = dao;
        this.szenarien = dao.findAll();
        this.setSelectedItem(this.szenarien.get(this.szenarien.size() - 1));
    }

    public void addElement(Object obj) {
        if (obj instanceof Szenarien) {
            this.szenarien.add((Szenarien)obj);
            this.fireIntervalAdded(this, this.szenarien.size() - 1, this.szenarien.size() - 1);
            if (this.szenarien.size() == 1 && this.selectedItem == null) {
                this.setSelectedItem(obj);
            }
        }
    }

    public void insertElementAt(Object obj, int index) {
        if (obj instanceof Szenarien) {
            this.szenarien.add(index, (Szenarien)obj);
            this.fireIntervalAdded(this, index, index);
        }
    }

    @Override
    public void removeElement(Object obj) {
        int index = this.szenarien.indexOf(obj);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    @Override
    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedItem) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.szenarien.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (this.selectedItem != null && !this.selectedItem.equals(anItem) || this.selectedItem == null && anItem != null) {
            this.selectedItem = anItem;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getElementAt(int index) {
        if (index >= 0 && index < this.szenarien.size()) {
            return this.szenarien.get(index);
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.szenarien.size();
    }

    public ComboBoxEditor getNameEditor() {
        return this.nameEditor;
    }

    public SpinnerModel[] getTempWerteModels() {
        return this.tempWerteModels;
    }

    public SpinnerModel[] getPhWerteModels() {
        return this.phWerteModels;
    }

    public SpinnerModel[] getLichtWerteModels() {
        return this.lichtWerteModels;
    }

    public void setModels(DimensionenModel dimensionenModel, FutterzeitModel futterzeitModel, SzenarienLebewesenModel szLebewesenModel) {
        this.dimensionenModel = dimensionenModel;
        this.futterzeitModel = futterzeitModel;
        this.szLebewesenModel = szLebewesenModel;
    }

    public void refreshModels() {
        Szenarien s = (Szenarien)this.getSelectedItem();
        s.getTempWerte().refreshWerte(this.tempWerteModels);
        s.getPhWerte().refreshWerte(this.phWerteModels);
        s.getLichtWerte().refreshWerte(this.lichtWerteModels);
        this.dimensionenModel.setSelectedItem(s.getDimensionen());
        this.futterzeitModel.setSzenarienFutterzeiten(s.getSzenarienFutterzeiten());
        this.szLebewesenModel.buildSzLebewesenTree(s, s.getSzenarienLebewesen());
    }

    public void createNewSzenario() {
        Szenarien newSzenario;
        try {
            newSzenario = (Szenarien)this.dao.makePersistent((Object)this.szenarien.get(0).clone());
        }
        catch (CloneNotSupportedException e) {
            newSzenario = (Szenarien)this.dao.makePersistent((Object)new Szenarien());
        }
        this.addElement(newSzenario);
        this.setSelectedItem(newSzenario);
        this.refreshModels();
    }

    public void saveSelectedSzenario() {
        Szenarien s = (Szenarien)this.getSelectedItem();
        s.getTempWerte().saveWerte(this.tempWerteModels);
        s.getPhWerte().saveWerte(this.phWerteModels);
        s.getLichtWerte().saveWerte(this.lichtWerteModels);
        s.setDimensionen((Dimensionen)this.dimensionenModel.getSelectedItem());
        Szenarien savedSzenario = (Szenarien)this.dao.makePersistent((Object)s);
        int index = this.szenarien.indexOf(s);
        this.szenarien.set(index, savedSzenario);
        this.setSelectedItem(savedSzenario);
        this.refreshModels();
    }

    public void deleteSelectedSzenario() {
        if (!this.getSelectedItem().equals(this.szenarien.get(0))) {
            Szenarien s = (Szenarien)this.getSelectedItem();
            this.dao.makeTransient((Object)s);
            this.removeElement(s);
        }
    }

    public boolean isInSzenario(Dimensionen d) {
        for (Szenarien s : this.szenarien) {
            if (!s.getDimensionen().equals(d)) continue;
            return true;
        }
        return false;
    }
}

