/*
 * Decompiled with CFR 0.152.
 */
package model;

import domain.Lebewesen;
import domain.Szenarien;
import domain.SzenarienLebewesen;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import model.SzenarienLebewesenNode;

public class SzenarienLebewesenModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    private final TreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
    private String strRoot;
    private DefaultMutableTreeNode treeRoot;
    private Set<SzenarienLebewesen> szLebewesen;
    private Szenarien currentSzenario;

    public SzenarienLebewesenModel(String strRoot) {
        super(null);
        this.strRoot = strRoot;
    }

    public void buildSzLebewesenTree(Szenarien s, Set<SzenarienLebewesen> szLebewesen) {
        this.currentSzenario = s;
        this.szLebewesen = szLebewesen;
        this.rebuildSzLebewesenTree();
    }

    private void rebuildSzLebewesenTree() {
        this.treeRoot = new DefaultMutableTreeNode(this.strRoot);
        for (SzenarienLebewesen szlw : this.szLebewesen) {
            SzenarienLebewesenNode parent = this.findOrCreateParentNode(szlw);
            parent.add(new SzenarienLebewesenNode(szlw, true));
        }
        this.setRoot(this.treeRoot);
    }

    private SzenarienLebewesenNode findOrCreateParentNode(SzenarienLebewesen szlw) {
        SzenarienLebewesenNode node;
        int i = 0;
        while (i < this.treeRoot.getChildCount()) {
            node = (SzenarienLebewesenNode)this.treeRoot.getChildAt(i);
            if (node.isOfTheSameTyp(szlw)) {
                return node;
            }
            ++i;
        }
        node = new SzenarienLebewesenNode(szlw, false);
        this.treeRoot.add(node);
        return node;
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void addLebewesen(Lebewesen lw, int menge) {
        if (this.currentSzenario != null && menge != 0) {
            SzenarienLebewesenNode child;
            SzenarienLebewesen szlw = this.findAndUpdateLebewesen(lw, menge);
            if (szlw != null) {
                SzenarienLebewesenNode parent = this.findOrCreateParentNode(szlw);
                child = this.findNode(szlw, parent);
                if (child != null) {
                    this.fireChanged(parent, child);
                }
            } else {
                szlw = new SzenarienLebewesen(this.currentSzenario, lw, menge);
                SzenarienLebewesenNode parent = this.findOrCreateParentNode(szlw);
                child = new SzenarienLebewesenNode(szlw, true);
                parent.add(child);
                this.szLebewesen.add(szlw);
                this.fireInserted(parent, child);
            }
            this.selectionModel.setSelectionPath(new TreePath(child.getPath()));
        }
    }

    private SzenarienLebewesenNode findNode(SzenarienLebewesen szlw, SzenarienLebewesenNode parent) {
        int i = 0;
        while (i < parent.getChildCount()) {
            SzenarienLebewesenNode child = (SzenarienLebewesenNode)parent.getChildAt(i);
            if (child.toSzenarienLebewesen().equals((Object)szlw)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    private SzenarienLebewesen findAndUpdateLebewesen(Lebewesen lw, int menge) {
        for (SzenarienLebewesen szlw : this.szLebewesen) {
            if (!szlw.isTheSame(lw)) continue;
            szlw.updateMenge(menge);
            return szlw;
        }
        return null;
    }

    public void removeSelectedLebewesen() {
        if (!this.selectionModel.isSelectionEmpty()) {
            TreePath[] paths;
            TreePath[] treePathArray = paths = this.selectionModel.getSelectionPaths();
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                SzenarienLebewesenNode child = (SzenarienLebewesenNode)path.getLastPathComponent();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)child.getParent();
                if (child != null && child.isLeaf()) {
                    this.removeNodeFromParent(child);
                    this.szLebewesen.remove(child.toSzenarienLebewesen());
                    this.fireRemoved(parent, child);
                    if (parent.getChildCount() == 0) {
                        this.removeNodeFromParent(parent);
                        this.fireRemoved(this.treeRoot, parent);
                    }
                }
                if (parent != null && parent.getChildCount() != 0) {
                    DefaultMutableTreeNode newSelectedNode = (DefaultMutableTreeNode)parent.getChildAt(0);
                    this.selectionModel.setSelectionPath(new TreePath(newSelectedNode.getPath()));
                }
                ++n2;
            }
        }
    }

    private void fireChanged(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        int[] childIndices = new int[]{parent.getIndex(child)};
        Object[] children = new Object[]{child};
        this.fireTreeNodesChanged(child, child.getPath(), childIndices, children);
        this.reload(child);
    }

    private void fireInserted(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        int[] childIndices = new int[]{parent.getIndex(child)};
        Object[] children = new Object[]{child};
        this.fireTreeNodesInserted(child, child.getPath(), childIndices, children);
        this.reload();
    }

    private void fireRemoved(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        int[] childIndices = new int[]{parent.getIndex(child)};
        Object[] children = new Object[]{child};
        this.fireTreeNodesChanged(child, child.getPath(), childIndices, children);
        this.reload(child);
    }
}

