/*
 * Decompiled with CFR 0.152.
 */
package model;

import dao.LebewesenDao;
import domain.Lebewesen;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import model.LebewesenNode;

public class LebewesenModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    private final TreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
    private String strRoot;
    private DefaultMutableTreeNode treeRoot;
    private List<Lebewesen> dbLebewesen;

    public LebewesenModel(String strRoot, LebewesenDao dao) {
        super(null);
        this.strRoot = strRoot;
        this.dbLebewesen = dao.findAll();
        this.buildDbLebewesenTree();
    }

    private void buildDbLebewesenTree() {
        this.treeRoot = new DefaultMutableTreeNode(this.strRoot);
        for (Lebewesen lw : this.dbLebewesen) {
            LebewesenNode parent = this.findOrCreateParentNode(lw);
            parent.add(new LebewesenNode(lw, true));
        }
        this.setRoot(this.treeRoot);
    }

    private LebewesenNode findOrCreateParentNode(Lebewesen lw) {
        LebewesenNode node;
        int i = 0;
        while (i < this.treeRoot.getChildCount()) {
            node = (LebewesenNode)this.treeRoot.getChildAt(i);
            if (node.isOfTheSameTyp(lw)) {
                return node;
            }
            ++i;
        }
        node = new LebewesenNode(lw, false);
        this.treeRoot.add(node);
        return node;
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public Lebewesen[] getSelectedLebewesen() {
        if (!this.selectionModel.isSelectionEmpty()) {
            TreePath[] paths = this.selectionModel.getSelectionPaths();
            Lebewesen[] lebewesen = new Lebewesen[paths.length];
            int i = 0;
            while (i < paths.length) {
                LebewesenNode node = (LebewesenNode)paths[i].getLastPathComponent();
                lebewesen[i] = node.toLebewesen();
                ++i;
            }
            return lebewesen;
        }
        return null;
    }
}

