/*
 * Decompiled with CFR 0.152.
 */
package model;

import dao.DimensionenDao;
import domain.Dimensionen;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import model.SzenarienModel;

public class DimensionenModel
extends AbstractListModel
implements MutableComboBoxModel,
Serializable {
    private static final long serialVersionUID = -7888833300976707376L;
    private DimensionenDao dao;
    private List<Dimensionen> dimensionen;
    private Object selectedItem;
    private Dimensionen newDimensionen;
    private SzenarienModel szenarienModel;
    private final SpinnerModel[] spinnerModels = new SpinnerModel[]{new SpinnerNumberModel(100, 20, 6485, 5), new SpinnerNumberModel(50, 20, 6485, 5), new SpinnerNumberModel(75, 20, 6485, 5)};

    public DimensionenModel(DimensionenDao dao) {
        this.dao = dao;
        this.dimensionen = dao.findAll();
    }

    public void addElement(Object obj) {
        if (obj instanceof Dimensionen) {
            this.dimensionen.add((Dimensionen)obj);
            this.fireIntervalAdded(this, this.dimensionen.size() - 1, this.dimensionen.size() - 1);
            if (this.dimensionen.size() == 1 && this.selectedItem == null) {
                this.setSelectedItem(obj);
            }
        }
    }

    public void insertElementAt(Object obj, int index) {
        if (obj instanceof Dimensionen) {
            this.dimensionen.add(index, (Dimensionen)obj);
            this.fireIntervalAdded(this, index, index);
        }
    }

    @Override
    public void removeElement(Object obj) {
        int index = this.dimensionen.indexOf(obj);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    @Override
    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedItem) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.dimensionen.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (this.selectedItem != null && !this.selectedItem.equals(anItem) || this.selectedItem == null && anItem != null) {
            this.selectedItem = anItem;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getElementAt(int index) {
        if (index >= 0 && index < this.dimensionen.size()) {
            return this.dimensionen.get(index);
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.dimensionen.size();
    }

    public void setModels(SzenarienModel szenarienModel) {
        this.szenarienModel = szenarienModel;
    }

    public SpinnerModel[] getSpinnerModels() {
        return this.spinnerModels;
    }

    public void refreshModels() {
        Dimensionen d = (Dimensionen)this.getSelectedItem();
        d.refreshWerte(this.spinnerModels);
    }

    public void createNewDimensionen() {
        Dimensionen d = (Dimensionen)this.getSelectedItem();
        if (d != null) {
            try {
                this.newDimensionen = d.clone();
                this.newDimensionen.refreshWerte(this.spinnerModels);
            }
            catch (CloneNotSupportedException e) {
                this.newDimensionen = new Dimensionen();
            }
        } else {
            this.newDimensionen = new Dimensionen();
        }
    }

    public void deleteIfNew() {
        if (this.newDimensionen != null) {
            this.newDimensionen = null;
        }
    }

    public void saveDimensionen() {
        if (this.newDimensionen != null) {
            this.newDimensionen.saveWerte(this.spinnerModels);
            Dimensionen d = (Dimensionen)this.dao.makePersistent((Object)this.newDimensionen);
            this.addElement(d);
            this.setSelectedItem(d);
            this.newDimensionen = null;
        } else {
            Dimensionen d = (Dimensionen)this.getSelectedItem();
            d.saveWerte(this.spinnerModels);
            this.dao.makePersistent((Object)d);
        }
    }

    public void deleteSelectedDimensionen() {
        Dimensionen d = (Dimensionen)this.getSelectedItem();
        if (!this.szenarienModel.isInSzenario(d)) {
            this.dao.makeTransient((Object)d);
            this.removeElement(d);
        }
    }
}

