/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import main.Aqua3EditorApplication;

public class AquaPreferences {
    private Preferences prefs;
    public static final String LANGUAGE = Locale.getDefault().getLanguage();
    public static final String COUNTRY = Locale.getDefault().getCountry();
    public static final String VARIANT = Locale.getDefault().getVariant();
    public static final int DEFAULT_WINDOW_STATE = 0;
    public static final GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    public static final Rectangle r = gc.getBounds();
    public static final int DEFAULT_WINDOW_WIDTH = 800;
    public static final int DEFAULT_WINDOW_HEIGHT = 600;
    public static final int DEFAULT_WINDOW_X = AquaPreferences.r.x + AquaPreferences.r.width / 2 - 400;
    public static final int DEFAULT_WINDOW_Y = AquaPreferences.r.y + AquaPreferences.r.height / 2 - 300;
    public static final String DEFAULT_LAF = UIManager.getSystemLookAndFeelClassName();
    public static final String LANGUAGE_KEY = "L";
    public static final String COUNTRY_KEY = "C";
    public static final String VARIANT_KEY = "V";
    public static final String WINDOW_STATE_KEY = "S";
    public static final String WINDOW_WIDTH_KEY = "W";
    public static final String WINDOW_HEIGHT_KEY = "H";
    public static final String WINDOW_X_KEY = "X";
    public static final String WINDOW_Y_KEY = "Y";
    public static final String LAF_KEY = "LAF";

    public AquaPreferences(Aqua3EditorApplication app) {
        this.prefs = Preferences.userNodeForPackage(app.getClass());
    }

    public Locale getLocale() {
        String language = this.prefs.get(LANGUAGE_KEY, LANGUAGE);
        String country = this.prefs.get(COUNTRY_KEY, COUNTRY);
        String variant = this.prefs.get(VARIANT_KEY, VARIANT);
        return new Locale(language, country, variant);
    }

    public void setLocale(Locale locale) {
        this.prefs.put(LANGUAGE_KEY, locale.getLanguage());
        this.prefs.put(COUNTRY_KEY, locale.getCountry());
        this.prefs.put(VARIANT_KEY, locale.getVariant());
    }

    public int getWindowState() {
        return this.prefs.getInt(WINDOW_STATE_KEY, 0);
    }

    public void setWindowState(int state) {
        this.prefs.putInt(WINDOW_STATE_KEY, state);
    }

    public Dimension getWindowSize() {
        int w = this.prefs.getInt(WINDOW_WIDTH_KEY, 800);
        int h = this.prefs.getInt(WINDOW_HEIGHT_KEY, 600);
        return new Dimension(w, h);
    }

    public void setWindowSize(Dimension size) {
        this.prefs.putInt(WINDOW_WIDTH_KEY, size.width);
        this.prefs.putInt(WINDOW_HEIGHT_KEY, size.height);
    }

    public Point getWindowPoint() {
        int x = this.prefs.getInt(WINDOW_X_KEY, DEFAULT_WINDOW_X);
        int y = this.prefs.getInt(WINDOW_Y_KEY, DEFAULT_WINDOW_Y);
        return new Point(x, y);
    }

    public void setWindowPoint(Point location) {
        this.prefs.putInt(WINDOW_X_KEY, location.x);
        this.prefs.putInt(WINDOW_Y_KEY, location.y);
    }

    public String getLafClassName() {
        return this.prefs.get(LAF_KEY, DEFAULT_LAF);
    }

    public void setLafClassName(String laf) {
        this.prefs.put(LAF_KEY, laf);
    }
}

