/*
 * Decompiled with CFR 0.152.
 */
package main;

import controller.Aqua3EditorController;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.naming.NamingException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import main.AquaContext;
import main.AquaPreferences;
import main.ErrorMessage;
import main.Resources;
import view.Aqua3EditorViewRoot;

public class Aqua3EditorApplication
extends JFrame {
    private static final long serialVersionUID = 1L;
    private AquaPreferences prefs = new AquaPreferences(this);
    private Aqua3EditorViewRoot rootPanel;

    public Aqua3EditorApplication() {
        this.init();
    }

    public void init() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Aqua3EditorApplication.this.initView();
                Aqua3EditorApplication.this.initFrame();
                Aqua3EditorApplication.this.initController();
            }
        });
    }

    private void initController() {
        try {
            AquaContext context = new AquaContext();
            new Aqua3EditorController(this, this.rootPanel, context);
        }
        catch (NamingException e) {
            ErrorMessage.show(1);
            System.exit(0);
        }
    }

    private void initView() {
        Resources.setResourceBundle(this.prefs.getLocale());
        this.setLookAndFeel(this.prefs.getLafClassName());
        this.rootPanel = new Aqua3EditorViewRoot(this);
    }

    private void initFrame() {
        this.setTitle(Resources.getString("Frame.title"));
        this.setBoundsAndState();
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Aqua3EditorApplication.this.saveAndExit();
            }
        });
    }

    private void setLookAndFeel(String lafClassName) {
        try {
            UIManager.setLookAndFeel(lafClassName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void setBoundsAndState() {
        this.setSize(this.prefs.getWindowSize());
        this.setLocation(this.prefs.getWindowPoint());
        this.setExtendedState(this.prefs.getWindowState());
    }

    public void saveAndExit() {
        this.saveBoundsAndState();
        this.saveLookAndFeel();
        System.exit(0);
    }

    private void saveBoundsAndState() {
        int windowState = this.getExtendedState();
        this.prefs.setWindowState(windowState);
        if (windowState == 0) {
            this.prefs.setWindowPoint(this.getLocation());
            this.prefs.setWindowSize(this.getSize());
        }
    }

    private void saveLookAndFeel() {
        this.prefs.setLafClassName(UIManager.getLookAndFeel().getClass().getName());
    }

    public static void main(String[] args) {
        new Aqua3EditorApplication();
    }
}

