/*
 * Decompiled with CFR 0.152.
 */
package main;

import controller.Aqua3EditorController;
import java.net.MalformedURLException;
import java.net.URL;
import javax.naming.NamingException;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import main.AquaContext;
import main.ErrorMessage;
import main.Resources;
import view.Aqua3EditorViewRoot;

public class Aqua3EditorApplet
extends JApplet {
    private static final long serialVersionUID = 1003016146497959856L;
    private Aqua3EditorViewRoot rootPanel;

    @Override
    public void init() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Aqua3EditorApplet.this.initView();
                Aqua3EditorApplet.this.initController();
            }
        });
    }

    private void initController() {
        try {
            AquaContext context = new AquaContext();
            new Aqua3EditorController(this, this.rootPanel, context);
        }
        catch (NamingException e) {
            ErrorMessage.show(1);
            System.exit(0);
        }
    }

    private void initView() {
        Resources.setResourceBundle(this.getLocale());
        this.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        this.rootPanel = new Aqua3EditorViewRoot(this);
    }

    public void setLookAndFeel(String lafClassName) {
        try {
            UIManager.setLookAndFeel(lafClassName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    public URL getURL(String filename) {
        URL codeBase = this.getCodeBase();
        URL url = null;
        try {
            url = new URL(codeBase, filename);
            System.out.println(url);
        }
        catch (MalformedURLException e) {
            System.err.println(e.getMessage());
            return null;
        }
        return url;
    }
}

