/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.AddFutterzeitAction;
import controller.AddLebewesenAction;
import controller.CancelDimensionenEditAction;
import controller.DeleteDimensionenAction;
import controller.DeleteFutterzeitAction;
import controller.DeleteSzeanrioAction;
import controller.DimensionenComboBoxAction;
import controller.EditDimensionenAction;
import controller.NewDimensionenAction;
import controller.NewSzeanrioAction;
import controller.ProgramExitAction;
import controller.RemoveLebewesenAction;
import controller.SaveDimensionenEditAction;
import controller.SaveSzeanrioAction;
import controller.SzenarienComboBoxAction;
import java.awt.Container;
import javax.swing.Action;
import main.AquaContext;
import main.Resources;
import model.DimensionenModel;
import model.FutterzeitModel;
import model.LebewesenModel;
import model.SzenarienLebewesenModel;
import model.SzenarienModel;
import view.Aqua3EditorViewRoot;

public class Aqua3EditorController {
    private Container parent;
    private Aqua3EditorViewRoot rootPanel;
    private AquaContext context;
    private SzenarienModel szenarienModel;
    private DimensionenModel dimensionenModel;
    private FutterzeitModel futterzeitModel;
    private LebewesenModel dbLebewesenModel;
    private SzenarienLebewesenModel szLebewesenModel;

    public Aqua3EditorController(Container parent, Aqua3EditorViewRoot rootPanel, AquaContext context) {
        this.parent = parent;
        this.rootPanel = rootPanel;
        this.context = context;
        this.initModels();
        this.initActions();
    }

    private void initModels() {
        this.szenarienModel = new SzenarienModel(this.context.getSzenarienDao());
        this.dimensionenModel = new DimensionenModel(this.context.getDimensionenDao());
        this.futterzeitModel = new FutterzeitModel();
        this.dbLebewesenModel = new LebewesenModel(Resources.getString("Szen.lwp_treeRoot"), this.context.getLebewesenDao());
        this.szLebewesenModel = new SzenarienLebewesenModel(Resources.getString("Szen.lwszp_treeRoot"));
        this.szenarienModel.setModels(this.dimensionenModel, this.futterzeitModel, this.szLebewesenModel);
        this.dimensionenModel.setModels(this.szenarienModel);
        this.szenarienModel.refreshModels();
        this.rootPanel.setSzenarienModels(this.szenarienModel, this.szenarienModel.getNameEditor());
        this.rootPanel.setAquariumModels(this.dimensionenModel, null);
        this.rootPanel.setTempModels(this.szenarienModel.getTempWerteModels());
        this.rootPanel.setPhModels(this.szenarienModel.getPhWerteModels());
        this.rootPanel.setLichtModels(this.szenarienModel.getLichtWerteModels(), "HH:mm");
        this.rootPanel.setFutterzeitModels(this.futterzeitModel, this.futterzeitModel.getSelectionModel(), this.futterzeitModel.getSpinnerModel(), "HH:mm");
        this.rootPanel.setDimensionenModels(this.dimensionenModel.getSpinnerModels());
        this.rootPanel.setDbLebewesenModels(this.dbLebewesenModel, this.dbLebewesenModel.getSelectionModel());
        this.rootPanel.setSzLebewesenModels(this.szLebewesenModel, this.szLebewesenModel.getSelectionModel());
    }

    private void initActions() {
        ProgramExitAction programExitAction = new ProgramExitAction(this.parent);
        SzenarienComboBoxAction szenarienComboBoxAction = new SzenarienComboBoxAction(this.szenarienModel);
        DimensionenComboBoxAction dimensionenComboBoxAction = new DimensionenComboBoxAction();
        NewSzeanrioAction newSzeanrioAction = new NewSzeanrioAction(this.szenarienModel);
        SaveSzeanrioAction saveSzeanrioAction = new SaveSzeanrioAction(this.szenarienModel);
        DeleteSzeanrioAction deleteSzeanrioAction = new DeleteSzeanrioAction(this.szenarienModel);
        NewDimensionenAction newDimensionenAction = new NewDimensionenAction(this.rootPanel, this.dimensionenModel);
        EditDimensionenAction editDimensionenAction = new EditDimensionenAction(this.rootPanel, this.dimensionenModel);
        DeleteDimensionenAction deleteDimensionenAction = new DeleteDimensionenAction(this.dimensionenModel);
        AddFutterzeitAction addFutterzeitAction = new AddFutterzeitAction(this.futterzeitModel);
        DeleteFutterzeitAction deleteFutterzeitAction = new DeleteFutterzeitAction(this.futterzeitModel);
        SaveDimensionenEditAction saveDimensionenEditAction = new SaveDimensionenEditAction(this.rootPanel, this.dimensionenModel);
        CancelDimensionenEditAction cancelDimensionenEditAction = new CancelDimensionenEditAction(this.rootPanel, this.dimensionenModel);
        AddLebewesenAction addLebewesenAction = new AddLebewesenAction(this.rootPanel, this.dbLebewesenModel, this.szLebewesenModel);
        RemoveLebewesenAction removeLebewesenAction = new RemoveLebewesenAction(this.szLebewesenModel);
        this.rootPanel.addMenuProgramItem(programExitAction);
        this.rootPanel.setSzenarienActions(new Action[]{szenarienComboBoxAction, newSzeanrioAction, saveSzeanrioAction, deleteSzeanrioAction});
        this.rootPanel.setAquariumActions(new Action[]{dimensionenComboBoxAction, newDimensionenAction, editDimensionenAction, deleteDimensionenAction});
        this.rootPanel.setFutterzeitActions(new Action[]{addFutterzeitAction, deleteFutterzeitAction});
        this.rootPanel.setLebewesenActions(new Action[]{addLebewesenAction, removeLebewesenAction});
        this.rootPanel.setDimensionenActions(new Action[]{saveDimensionenEditAction, cancelDimensionenEditAction});
    }
}

