/*
 * Decompiled with CFR 0.152.
 */
package domain;

import domain.Lebewesen;
import domain.Szenarien;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="SZENARIEN_LEBEWESEN")
public class SzenarienLebewesen
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SzenarienLebewesenId szenarienLebewesenId = new SzenarienLebewesenId();
    private int lebewesenmenge;
    private Lebewesen lebewesen;
    private Szenarien szenarien;

    public SzenarienLebewesen() {
    }

    public SzenarienLebewesen(Szenarien szenarien, Lebewesen lebewesen, int menge) {
        this.lebewesenmenge = menge;
        this.lebewesen = lebewesen;
        this.szenarien = szenarien;
        this.szenarienLebewesenId.szenarienId = szenarien.getSzenarienId();
        this.szenarienLebewesenId.lebewesenId = lebewesen.getLebewesenId();
    }

    @EmbeddedId
    public SzenarienLebewesenId getSzenarienLebewesenId() {
        return this.szenarienLebewesenId;
    }

    public void setSzenarienLebewesenId(SzenarienLebewesenId szenarienLebewesenId) {
        this.szenarienLebewesenId = szenarienLebewesenId;
    }

    @Column(name="LEBEWESENMENGE", nullable=false)
    public int getLebewesenmenge() {
        return this.lebewesenmenge;
    }

    public void setLebewesenmenge(int lebewesenmenge) {
        this.lebewesenmenge = lebewesenmenge;
    }

    @ManyToOne
    @JoinColumn(name="LEBEWESEN_ID", nullable=false, insertable=false, updatable=false)
    public Lebewesen getLebewesen() {
        return this.lebewesen;
    }

    public void setLebewesen(Lebewesen lebewesen) {
        this.lebewesen = lebewesen;
    }

    @ManyToOne
    @JoinColumn(name="SZENARIEN_ID", nullable=false, insertable=false, updatable=false)
    public Szenarien getSzenarien() {
        return this.szenarien;
    }

    public void setSzenarien(Szenarien szenarien) {
        this.szenarien = szenarien;
    }

    public void updateMenge(int menge) {
        this.setLebewesenmenge(this.getLebewesenmenge() + menge);
    }

    public boolean isTheSame(Lebewesen lw) {
        return this.getLebewesen().isTheSame(lw);
    }

    public String toString() {
        return this.getLebewesen() + " (" + this.getLebewesenmenge() + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lebewesenmenge;
        result = 31 * result + (this.szenarienLebewesenId == null ? 0 : this.szenarienLebewesenId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SzenarienLebewesen other = (SzenarienLebewesen)obj;
        if (this.lebewesenmenge != other.lebewesenmenge) {
            return false;
        }
        return !(this.szenarienLebewesenId == null ? other.szenarienLebewesenId != null : !this.szenarienLebewesenId.equals(other.szenarienLebewesenId));
    }

    @Embeddable
    public static class SzenarienLebewesenId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long szenarienId;
        private Long lebewesenId;

        public SzenarienLebewesenId() {
        }

        public SzenarienLebewesenId(Long szenarienId, Long lebewesenId) {
            this.szenarienId = szenarienId;
            this.lebewesenId = lebewesenId;
        }

        @Column(name="SZENARIEN_ID")
        public Long getSzenarienId() {
            return this.szenarienId;
        }

        public void setSzenarienId(Long szenarienId) {
            this.szenarienId = szenarienId;
        }

        @Column(name="LEBEWESEN_ID")
        public Long getLebewesenId() {
            return this.lebewesenId;
        }

        public void setLebewesenId(Long lebewesenId) {
            this.lebewesenId = lebewesenId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.lebewesenId == null ? 0 : this.lebewesenId.hashCode());
            result = 31 * result + (this.szenarienId == null ? 0 : this.szenarienId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SzenarienLebewesenId other = (SzenarienLebewesenId)obj;
            if (this.lebewesenId == null ? other.lebewesenId != null : !this.lebewesenId.equals(other.lebewesenId)) {
                return false;
            }
            return !(this.szenarienId == null ? other.szenarienId != null : !this.szenarienId.equals(other.szenarienId));
        }
    }
}

