/*
 * Decompiled with CFR 0.152.
 */
package dao.ejb;

import dao.GenericDAO;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.ejb.HibernateEntityManager;

public abstract class GenericEJB3DAO<T, ID extends Serializable>
implements GenericDAO<T, ID> {
    private Class<T> entityBeanType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private EntityManager em;

    @PersistenceContext
    public void setEntityManager(EntityManager em) {
        this.em = em;
    }

    protected EntityManager getEntityManager() {
        if (this.em == null) {
            throw new IllegalStateException("EntityManager has not been set on DAO before usage");
        }
        return this.em;
    }

    public Class<T> getEntityBeanType() {
        return this.entityBeanType;
    }

    @Override
    public T findById(ID id, boolean lock) {
        Object entity;
        if (lock) {
            entity = this.getEntityManager().find(this.getEntityBeanType(), id);
            this.em.lock(entity, LockModeType.WRITE);
        } else {
            entity = this.getEntityManager().find(this.getEntityBeanType(), id);
        }
        return (T)entity;
    }

    @Override
    public List<T> findAll() {
        return this.getEntityManager().createQuery("from " + this.getEntityBeanType().getName()).getResultList();
    }

    @Override
    public List<T> findByExample(T exampleInstance, String ... excludeProperty) {
        Criteria crit = ((HibernateEntityManager)this.getEntityManager()).getSession().createCriteria(this.getEntityBeanType());
        Example example = Example.create(exampleInstance);
        String[] stringArray = excludeProperty;
        int n = excludeProperty.length;
        int n2 = 0;
        while (n2 < n) {
            String exclude = stringArray[n2];
            example.excludeProperty(exclude);
            ++n2;
        }
        crit.add((Criterion)example);
        return crit.list();
    }

    @Override
    public T makePersistent(T entity) {
        return (T)this.getEntityManager().merge(entity);
    }

    @Override
    public void makeTransient(T entity) {
        Object merged = this.getEntityManager().merge(entity);
        this.getEntityManager().remove(merged);
    }

    public void flush() {
        this.getEntityManager().flush();
    }

    public void clear() {
        this.getEntityManager().clear();
    }

    protected List<T> findByCriteria(Criterion ... criterion) {
        Session session = ((HibernateEntityManager)this.getEntityManager()).getSession();
        Criteria crit = session.createCriteria(this.getEntityBeanType());
        Criterion[] criterionArray = criterion;
        int n = criterion.length;
        int n2 = 0;
        while (n2 < n) {
            Criterion c = criterionArray[n2];
            crit.add(c);
            ++n2;
        }
        return crit.list();
    }
}

