/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.GridLayout;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import main.ErrorMessage;
import main.Resources;

public class PanelSzenarioSpinners
extends JPanel {
    private static final long serialVersionUID = 5460207612321317629L;
    private JSpinner firstSpinner = new JSpinner();
    private JSpinner secondSpinner = new JSpinner();

    public PanelSzenarioSpinners(String keyTitle, String keyLabel1, String keyLabel2) {
        super(new GridLayout(2, 2, 5, 5));
        this.setBorder(BorderFactory.createTitledBorder(Resources.getString(keyTitle)));
        this.add(new JLabel(Resources.getString(keyLabel1), 4));
        this.add(this.firstSpinner);
        this.add(new JLabel(Resources.getString(keyLabel2), 4));
        this.add(this.secondSpinner);
    }

    public void setNumberModel(double value1, double value2, double minimum, double maximum, double stepSize) {
        this.firstSpinner.setModel(new SpinnerNumberModel(value1, minimum, maximum, stepSize));
        this.secondSpinner.setModel(new SpinnerNumberModel(value2, minimum, maximum, stepSize));
    }

    public void setDateModel(String date1, String date2, String pattern, int calendarField) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            this.firstSpinner.setModel(new SpinnerDateModel(sdf.parse(date1), null, null, calendarField));
            this.secondSpinner.setModel(new SpinnerDateModel(sdf.parse(date2), null, null, calendarField));
            this.firstSpinner.setEditor(new JSpinner.DateEditor(this.firstSpinner, pattern));
            this.secondSpinner.setEditor(new JSpinner.DateEditor(this.secondSpinner, pattern));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void setFirstValue(Object value) {
        this.firstSpinner.setValue(value);
    }

    public void setSecondValue(Object value) {
        this.secondSpinner.setValue(value);
    }

    public double getFirstNumber() {
        try {
            return Double.parseDouble(this.firstSpinner.getValue().toString());
        }
        catch (NumberFormatException nfe) {
            ErrorMessage.show(nfe.getMessage().substring(17), 2);
            return 0.0;
        }
    }

    public double getSecondNumber() {
        try {
            return Double.parseDouble(this.secondSpinner.getValue().toString());
        }
        catch (NumberFormatException nfe) {
            ErrorMessage.show(nfe.getMessage().substring(17), 2);
            return 0.0;
        }
    }

    public Date getFirstDate() {
        return (Date)this.firstSpinner.getValue();
    }

    public Date getSecondDate() {
        return (Date)this.secondSpinner.getValue();
    }

    public boolean checkNumbers() {
        if (this.getFirstNumber() < this.getSecondNumber()) {
            return true;
        }
        ErrorMessage.show(5);
        return false;
    }
}

