/*
 * Decompiled with CFR 0.152.
 */
package view;

import dao.AquaDaoException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import main.ErrorMessage;
import main.Resources;
import model.SzenarioFutterzeit;

public class PanelSzenarioList
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 7371191512126336454L;
    private Dimension listPanePreferredSize = new Dimension(55, 70);
    private JSpinner spinner = new JSpinner();
    private JList listView = new JList();
    private SzenarioFutterzeit listModel = null;

    public PanelSzenarioList() {
        super(new BorderLayout(5, 0));
        this.setBorder(BorderFactory.createTitledBorder(Resources.getString("Szen.fzp_border")));
        this.add((Component)this.getWestPanel(), "West");
        this.add((Component)this.getListPane(), "Center");
    }

    private JPanel getWestPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel buttonsPanel = new JPanel(new GridLayout(2, 1, 0, 5));
        buttonsPanel.add(this.getButton("Szen.fzp_addButton", "fzadd", this));
        buttonsPanel.add(this.getButton("Szen.fzp_deleteButton", "fzdel", this));
        panel.add((Component)this.spinner, "North");
        panel.add((Component)buttonsPanel, "South");
        return panel;
    }

    private JScrollPane getListPane() {
        JScrollPane listPane = new JScrollPane(this.listView);
        listPane.setPreferredSize(this.listPanePreferredSize);
        return listPane;
    }

    private JButton getButton(String key, String cmd, ActionListener l) {
        JButton button = new JButton(Resources.getString(key));
        button.setActionCommand(cmd);
        button.addActionListener(l);
        return button;
    }

    public void setSpinnerModel() {
        this.spinner.setModel(new SpinnerDateModel());
        this.spinner.setEditor(new JSpinner.DateEditor(this.spinner, "HH:mm"));
    }

    public void setListModel(int szen_id) {
        try {
            this.listModel = new SzenarioFutterzeit(szen_id);
            this.listView.setModel(this.listModel);
            this.listView.setSelectionMode(0);
        }
        catch (AquaDaoException e) {
            ErrorMessage.show(1);
        }
    }

    public void saveList(int szen_id) {
        try {
            this.listModel.save(szen_id);
        }
        catch (AquaDaoException e) {
            ErrorMessage.show(1);
        }
    }

    public void deleteList(int szen_id) {
        try {
            this.listModel.delete(szen_id);
        }
        catch (AquaDaoException e) {
            ErrorMessage.show(1);
        }
    }

    public boolean checkList() {
        if (this.listModel.getSize() > 0) {
            return true;
        }
        ErrorMessage.show(4);
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equalsIgnoreCase("fzadd")) {
            this.listModel.add(this.spinner.getValue());
        } else if (cmd.equalsIgnoreCase("fzdel") && this.listView.getSelectedIndex() != -1) {
            this.listModel.remove(this.listView.getSelectedIndex());
        }
        this.listView.setSelectedIndex(this.listModel.getSize() - 1);
    }
}

