/*
 * Decompiled with CFR 0.152.
 */
package view;

import dao.AquaDaoException;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import main.ErrorMessage;
import main.Resources;
import model.Lebewesen;
import view.ILebewesenRefresher;
import view.PanelSzenarioTrees;

public class PanelSzenarioLebewesen
extends JPanel
implements ActionListener,
ILebewesenRefresher {
    private static final long serialVersionUID = 6368093942707988148L;
    private PanelSzenarioTrees dblwPanel = null;
    private PanelSzenarioTrees szlwPanel = null;
    private JButton lwAddButton;
    private JButton lwRemButton;
    private int SzenarioId;

    public PanelSzenarioLebewesen() {
        BoxLayout layout = new BoxLayout(this, 0);
        this.setLayout(layout);
        this.setBorder(BorderFactory.createTitledBorder(Resources.getString("Szen.lw_border")));
        this.dblwPanel = new PanelSzenarioTrees("Szen.lwinfp_text", true);
        this.szlwPanel = new PanelSzenarioTrees("Szen.lwszinfp_text", false);
        this.add(this.szlwPanel);
        this.add(this.getLebewesenEditPanel());
        this.add(this.dblwPanel);
    }

    private JPanel getLebewesenEditPanel() {
        JPanel panel = new JPanel();
        BoxLayout layout = new BoxLayout(panel, 1);
        panel.setLayout(layout);
        this.lwAddButton = this.getButton("Szen.lwp_addButton", "lwadd", this);
        this.lwRemButton = this.getButton("Szen.lwp_deleteButton", "lwrem", this);
        this.lwAddButton.setEnabled(false);
        this.lwRemButton.setEnabled(false);
        panel.add(this.lwAddButton);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(this.lwRemButton);
        return panel;
    }

    private JButton getButton(String key, String actionCommand, ActionListener l) {
        JButton button = new JButton(Resources.getString(key));
        button.setActionCommand(actionCommand);
        button.addActionListener(l);
        return button;
    }

    public void setModels() throws AquaDaoException {
        this.dblwPanel.setModel("Szen.lwp_treeRoot", this.SzenarioId * -1);
        this.szlwPanel.setModel("Szen.lwszp_treeRoot", this.SzenarioId);
        this.dblwPanel.setRefresher(this);
        this.szlwPanel.setRefresher(this);
    }

    public void setValues(int szen_id) throws AquaDaoException {
        this.SzenarioId = szen_id;
        this.refreshLebewesenPanles();
    }

    public void setDefaults() throws AquaDaoException {
        this.SzenarioId = 0;
        this.refreshLebewesenPanles();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        try {
            if (cmd.equalsIgnoreCase("lwadd")) {
                this.szlwPanel.add(this.dblwPanel.selectedLebewesen());
            } else if (cmd.equalsIgnoreCase("lwrem")) {
                this.szlwPanel.removeSelectedLebewesen();
            }
        }
        catch (AquaDaoException ade) {
            ErrorMessage.show(1);
        }
    }

    private void refreshLebewesenPanles() throws AquaDaoException {
        this.dblwPanel.refresh(this.SzenarioId * -1);
        this.szlwPanel.refresh(this.SzenarioId);
    }

    @Override
    public void LebenwesenDeselected(Lebewesen curSel, PanelSzenarioTrees parent) {
        if (this.szlwPanel == parent) {
            this.lwRemButton.setEnabled(false);
        }
        parent.refreshInfo(null);
    }

    @Override
    public void LebenwesenSelected(Lebewesen curSel, PanelSzenarioTrees parent) {
        if (this.szlwPanel == parent) {
            this.lwRemButton.setEnabled(true);
        } else {
            this.lwAddButton.setEnabled(true);
        }
        parent.refreshInfo(curSel);
    }

    @Override
    public void refreshBothSides() {
        this.dblwPanel.updateTree();
        this.szlwPanel.updateTree();
    }

    @Override
    public void deleteButtonPressed(PanelSzenarioTrees parent) {
        try {
            if (this.szlwPanel == parent && this.lwRemButton.isEnabled()) {
                this.szlwPanel.removeSelectedLebewesen();
            }
        }
        catch (AquaDaoException ade) {
            ErrorMessage.show(1);
        }
    }

    @Override
    public void addButtonPressed(PanelSzenarioTrees parent) {
        try {
            if (this.dblwPanel == parent && this.lwAddButton.isEnabled()) {
                this.szlwPanel.add(this.dblwPanel.selectedLebewesen());
            }
        }
        catch (AquaDaoException ade) {
            ErrorMessage.show(1);
        }
    }
}

