/*
 * Decompiled with CFR 0.152.
 */
package view;

import dao.AquaDaoException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import main.Constraints;
import main.ErrorMessage;
import main.Resources;
import model.Dimensionen;
import model.DimensionenList;
import model.Szenarien;
import model.Szenario;
import view.PanelDimensionen;
import view.PanelSzenarioCombo;
import view.PanelSzenarioLebewesen;
import view.PanelSzenarioList;
import view.PanelSzenarioSpinners;

public class PanelSzenario
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 9081299795592612955L;
    private PanelSzenarioCombo szenPanel = null;
    private PanelSzenarioCombo aquaPanel = null;
    private PanelSzenarioSpinners tempPanel = null;
    private PanelSzenarioSpinners phPanel = null;
    private PanelSzenarioSpinners lichtPanel = null;
    private PanelSzenarioList fzPanel = null;
    private PanelSzenarioLebewesen lwPanel = null;
    private PanelDimensionen dimPanel = null;
    private int selectedSzenario = -1;
    private Szenarien szenModel = null;
    private DimensionenList aquaModel = null;

    public PanelSzenario() {
        super(new BorderLayout());
        this.add((Component)this.getMainNorthPanel(), "North");
        this.add((Component)this.getMainCenterPanel(), "Center");
        this.setModels();
    }

    private JPanel getMainNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.tempPanel = new PanelSzenarioSpinners("Szen.tempp_border", "Szen.tempp_minLabel", "Szen.tempp_maxLabel");
        this.phPanel = new PanelSzenarioSpinners("Szen.php_border", "Szen.php_minLabel", "Szen.php_maxLabel");
        this.lichtPanel = new PanelSzenarioSpinners("Szen.lichtp_border", "Szen.lichtp_einLabel", "Szen.lichtp_ausLabel");
        this.fzPanel = new PanelSzenarioList();
        panel.add((Component)this.getSzenarioPanel(), new Constraints(0, 0, 6, 1).setWeight(1.0, 0.0).setAnchor(18).setFill(2).setInsets(5, 5, 0, 5));
        panel.add((Component)this.getAquariumPanel(), new Constraints(0, 1, 6, 1).setWeight(1.0, 0.0).setAnchor(17).setFill(2));
        panel.add((Component)this.tempPanel, new Constraints(0, 2, 2, 2).setWeight(1.0, 0.0).setAnchor(17).setFill(2));
        panel.add((Component)this.phPanel, new Constraints(2, 2, 2, 2).setWeight(1.0, 0.0).setAnchor(17).setFill(2));
        panel.add((Component)this.lichtPanel, new Constraints(4, 2, 2, 2).setWeight(1.0, 0.0).setAnchor(17).setFill(2));
        panel.add((Component)this.fzPanel, new Constraints(6, 1, 4, 3).setWeight(1.0, 0.0).setAnchor(17).setFill(1));
        return panel;
    }

    private JPanel getMainCenterPanel() {
        this.lwPanel = new PanelSzenarioLebewesen();
        return this.lwPanel;
    }

    private JPanel getSzenarioPanel() {
        this.szenPanel = new PanelSzenarioCombo();
        this.szenPanel.setComboBox(true, "szenchange", this);
        this.szenPanel.addButton("Szen.newButton", "szennew", this);
        this.szenPanel.addButton("Szen.saveButton", "szensave", this);
        this.szenPanel.addButton("Szen.deleteButton", "szendel", this);
        return this.szenPanel;
    }

    private JPanel getAquariumPanel() {
        this.aquaPanel = new PanelSzenarioCombo("Szen.aqp_border");
        this.aquaPanel.setComboBox(false, "aquachange", this);
        this.aquaPanel.addButton("Szen.aqp_newButton", "aquanew", this);
        this.aquaPanel.addButton("Szen.aqp_editButton", "aquaedit", this);
        this.aquaPanel.addButton("Szen.aqp_deleteButton", "aquadel", this);
        return this.aquaPanel;
    }

    private void setModels() {
        try {
            this.szenModel = new Szenarien();
            this.szenPanel.setModel(this.szenModel);
            this.aquaModel = new DimensionenList();
            this.aquaPanel.setModel(this.aquaModel);
            this.lwPanel.setModels();
            if (this.szenModel.getSize() > 0) {
                this.setSpinnerModels();
                this.setValues();
            } else {
                this.setDefaults();
            }
        }
        catch (AquaDaoException e) {
            ErrorMessage.show(1);
            this.setVisible(false);
        }
    }

    private void setSpinnerModels() {
        this.tempPanel.setNumberModel(22.0, 28.0, 15.0, 35.0, 0.5);
        this.phPanel.setNumberModel(5.0, 8.0, 0.0, 10.0, 0.5);
        this.lichtPanel.setDateModel("05:00", "21:00", "HH:mm", 11);
        this.fzPanel.setSpinnerModel();
    }

    private void setValues() throws AquaDaoException {
        this.selectedSzenario = this.szenPanel.getSelectedIndex();
        Szenario s = (Szenario)this.szenModel.getElementAt(this.selectedSzenario);
        this.aquaPanel.setSelectedIndex(this.aquaModel.findId(s.getDim_id()));
        this.tempPanel.setFirstValue(s.getTempMin());
        this.tempPanel.setSecondValue(s.getTempMax());
        this.phPanel.setFirstValue(s.getPhMin());
        this.phPanel.setSecondValue(s.getPhMax());
        this.lichtPanel.setFirstValue(s.getLichtEin());
        this.lichtPanel.setSecondValue(s.getLichtAus());
        this.fzPanel.setListModel(s.getId());
        this.lwPanel.setValues(s.getId());
    }

    private void setDefaults() throws AquaDaoException {
        this.szenPanel.setSelectedItem(Resources.getString("Szen.default_name"));
        this.selectedSzenario = -1;
        if (this.aquaModel.getSize() == 0) {
            this.aquaModel.create();
        }
        this.fzPanel.setListModel(0);
        this.setSpinnerModels();
        this.lwPanel.setDefaults();
    }

    private boolean showDimensionenDialog(Object model) {
        if (this.dimPanel == null) {
            this.dimPanel = new PanelDimensionen();
        }
        return this.dimPanel.showDialog(this, model);
    }

    private void saveSzenario() throws AquaDaoException {
        String name = this.szenPanel.getSelectedItem().toString();
        if (name.length() > 0 && this.tempPanel.checkNumbers() && this.phPanel.checkNumbers() && this.fzPanel.checkList()) {
            int szen_id = this.szenModel.save(this.selectedSzenario, name, this.aquaModel.getId(this.aquaPanel.getSelectedIndex()), this.tempPanel.getFirstNumber(), this.tempPanel.getSecondNumber(), this.phPanel.getFirstNumber(), this.phPanel.getSecondNumber(), this.lichtPanel.getFirstDate(), this.lichtPanel.getSecondDate());
            this.fzPanel.saveList(szen_id);
            if (this.selectedSzenario == -1) {
                this.selectedSzenario = this.szenModel.getSize() - 1;
            }
            this.szenPanel.setSelectedIndex(this.selectedSzenario);
        }
    }

    private void deleteSzenario() throws AquaDaoException {
        int szen_id = this.szenModel.delete(this.szenPanel.getSelectedIndex());
        this.fzPanel.deleteList(szen_id);
        if (this.szenModel.getSize() == 0) {
            this.setDefaults();
        }
    }

    private void createAquarium() throws AquaDaoException {
        Dimensionen object = this.aquaModel.create();
        if (this.showDimensionenDialog(object)) {
            this.aquaModel.save(object);
        } else {
            this.aquaModel.removeElement(object);
        }
    }

    private void editAquarium() throws AquaDaoException {
        Object object = this.aquaPanel.getSelectedItem();
        if (this.showDimensionenDialog(object)) {
            this.aquaModel.save(object);
        }
    }

    private void deleteAquarium() throws AquaDaoException {
        int index = this.aquaPanel.getSelectedIndex();
        String name = this.szenModel.isInUse(this.aquaModel.getId(index));
        if (name == null) {
            this.aquaModel.delete(index);
        } else {
            ErrorMessage.show(3, name);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        try {
            if (cmd.equals("szenchange") && this.szenPanel.getSelectedIndex() != -1) {
                this.setValues();
            } else if (cmd.equals("szennew")) {
                this.setDefaults();
            } else if (cmd.equals("szensave")) {
                this.saveSzenario();
            } else if (cmd.equals("szendel") && this.szenPanel.getSelectedIndex() != -1) {
                this.deleteSzenario();
            } else if (cmd.equals("aquanew")) {
                this.createAquarium();
            } else if (cmd.equals("aquaedit")) {
                this.editAquarium();
            } else if (cmd.equals("aquadel") && this.aquaPanel.getSelectedIndex() != -1) {
                this.deleteAquarium();
            }
        }
        catch (AquaDaoException ade) {
            ErrorMessage.show(1);
        }
    }
}

