/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import main.ErrorMessage;
import main.Resources;
import model.Dimensionen;

public class PanelDimensionen
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -4858837190922870641L;
    private boolean save;
    private JDialog dialog;
    private JSpinner lSpinner = new JSpinner();
    private JSpinner bSpinner = new JSpinner();
    private JSpinner hSpinner = new JSpinner();
    private JSpinner[] spinners = new JSpinner[]{this.lSpinner, this.bSpinner, this.hSpinner};
    private Dimensionen dimensionen = null;

    public PanelDimensionen() {
        super(new BorderLayout());
        this.add((Component)this.getCenterPanel(), "Center");
        this.add((Component)this.getSouthPanel(), "South");
    }

    private JPanel getCenterPanel() {
        JPanel innerPanel = new JPanel(new GridLayout(3, 2, 5, 5));
        innerPanel.add(new JLabel(Resources.getString("DimPanel.length_label")));
        innerPanel.add(this.lSpinner);
        innerPanel.add(new JLabel(Resources.getString("DimPanel.width_label")));
        innerPanel.add(this.bSpinner);
        innerPanel.add(new JLabel(Resources.getString("DimPanel.height_label")));
        innerPanel.add(this.hSpinner);
        JPanel outerPanel = new JPanel();
        outerPanel.add(innerPanel);
        return outerPanel;
    }

    private JPanel getSouthPanel() {
        JPanel panel = new JPanel();
        panel.add(this.getButton("DimPanel.saveButton", "dimsave", this));
        panel.add(this.getButton("DimPanel.cancelButton", "dimcanc", this));
        return panel;
    }

    private void setModel(Object model) {
        this.dimensionen = (Dimensionen)model;
        int i = 0;
        while (i < this.spinners.length) {
            this.spinners[i].setModel(new SpinnerNumberModel(this.dimensionen.getValues()[i], 20, 6485, 5));
            ++i;
        }
    }

    private JButton getButton(String key, String actionCommand, ActionListener l) {
        JButton button = new JButton(Resources.getString(key));
        button.setActionCommand(actionCommand);
        button.addActionListener(l);
        return button;
    }

    private boolean save() {
        try {
            this.dimensionen.setValues(this.lSpinner.getValue(), this.bSpinner.getValue(), this.hSpinner.getValue());
        }
        catch (NumberFormatException nfe) {
            ErrorMessage.show(nfe.getMessage().substring(17), 2);
            return false;
        }
        return true;
    }

    public boolean showDialog(Component parent, Object model) {
        Frame owner;
        this.save = false;
        this.setModel(model);
        Frame frame = owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (this.dialog == null || this.dialog.getOwner() != owner) {
            this.dialog = new JDialog(owner, true);
            this.dialog.add(this);
            this.dialog.pack();
        }
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.setTitle(Resources.getString("DimDialog.title"));
        this.dialog.setResizable(false);
        this.dialog.setVisible(true);
        return this.save;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("dimsave") && this.save()) {
            this.dialog.setVisible(false);
            this.save = true;
        } else if (cmd.equals("dimcanc")) {
            this.dialog.setVisible(false);
        }
    }
}

