/*
 * Decompiled with CFR 0.152.
 */
package model;

import dao.AquaDaoException;
import dao.AquaDaoFactory;
import dao.LebewesenDao;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import model.Lebewesen;
import model.LebewesenNode;
import model.LebewesenTyp;
import model.LebewesenTypSzenario;
import view.ILebewesenRefresher;
import view.PanelSzenarioTrees;

public class LebewesenModel
extends DefaultTreeModel
implements TreeSelectionListener,
KeyListener,
MouseListener {
    private static final long serialVersionUID = 3967724499036108108L;
    private final int INSERTED = 0;
    private final int UPDATED = 2;
    private DefaultMutableTreeNode m_root;
    private LebewesenDao m_sqlData;
    private int m_SzenarioId;
    private LebewesenNode m_curSelection = null;
    private ILebewesenRefresher m_refresher;
    private PanelSzenarioTrees m_Parent;
    private JTree m_tree;
    private boolean isInSelected = false;

    public LebewesenModel(String strRoot, int inSzenario) throws AquaDaoException {
        super(null);
        this.m_SzenarioId = inSzenario;
        this.m_sqlData = AquaDaoFactory.getInstance().getLebewesenDao();
        this.m_root = this.m_sqlData.Build_LebewesenTree(strRoot, this.m_SzenarioId, this.isInSelected);
        this.setRoot(this.m_root);
    }

    public static LebewesenNode findOrCreateParentTyp(DefaultMutableTreeNode root, Lebewesen l, boolean[] created) {
        LebewesenNode n;
        int i = 0;
        while (i < root.getChildCount()) {
            n = (LebewesenNode)root.getChildAt(i);
            if (n.isTyp(l)) {
                return n;
            }
            ++i;
        }
        n = l.BuildNode(false);
        root.add(n);
        if (created != null) {
            created[0] = true;
        }
        return n;
    }

    @Override
    public void valueChanged(TreeSelectionEvent arg0) {
        TreePath t = arg0.getOldLeadSelectionPath();
        if (t != null && t.getParentPath() != null) {
            this.m_refresher.LebenwesenDeselected(((LebewesenNode)t.getLastPathComponent()).toLebewesen(), this.m_Parent);
        }
        this.m_curSelection = null;
        t = arg0.getNewLeadSelectionPath();
        if (t != null && t.getParentPath() != null) {
            this.m_curSelection = (LebewesenNode)t.getLastPathComponent();
        }
        if (this.m_curSelection != null && this.m_curSelection.getChildCount() == 0) {
            this.m_refresher.LebenwesenSelected(this.m_curSelection.toLebewesen(), this.m_Parent);
        }
    }

    public LebewesenNode currentSelection() {
        return this.m_curSelection;
    }

    private LebewesenNode findLebewesen(LebewesenNode parent, Lebewesen l) {
        int i = 0;
        while (i < parent.getChildCount()) {
            LebewesenNode n = (LebewesenNode)parent.getChildAt(i);
            if (n.isSame(l)) {
                return n;
            }
            ++i;
        }
        return null;
    }

    public void add(Lebewesen l) throws AquaDaoException {
        LebewesenNode nl;
        int menge = 0;
        if (this.m_SzenarioId > 0) {
            String ret = JOptionPane.showInputDialog("Wie viele " + l.nodeName() + "?", (Object)1);
            if (ret == null || ret.length() == 0) {
                return;
            }
            menge = Integer.parseInt(ret);
            this.m_sqlData.addToSzenario(l.getId(), this.m_SzenarioId, menge);
            l = new LebewesenTypSzenario((LebewesenTyp)l, this.m_SzenarioId, menge);
        }
        boolean[] created = new boolean[]{false};
        LebewesenNode parent = LebewesenModel.findOrCreateParentTyp(this.m_root, l, created);
        if (created[0]) {
            this.fireChanges(parent, 0);
            TreePath tp = new TreePath(parent.getPath());
            this.m_tree.scrollPathToVisible(tp);
        }
        if ((nl = this.findLebewesen(parent, l)) != null) {
            nl.updateMenge(menge);
        } else {
            nl = l.BuildNode(true);
            parent.add(nl);
        }
        this.fireChanges(nl, 0);
    }

    public void removeSelectedLebewesen() throws AquaDaoException {
        if (this.m_curSelection == null) {
            return;
        }
        if (this.m_SzenarioId > 0) {
            Lebewesen l = this.m_curSelection.toLebewesen();
            this.m_sqlData.removeFromSzenario(l.getId(), this.m_SzenarioId);
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.m_curSelection.getParent();
        this.removeNodeFromParent(this.m_curSelection);
        if (parent.getChildCount() == 0) {
            this.removeNodeFromParent(parent);
        }
    }

    public void setRefresher(ILebewesenRefresher r, PanelSzenarioTrees treesPanel) {
        this.m_refresher = r;
        this.m_Parent = treesPanel;
    }

    public void refresh(int szenarioId) throws AquaDaoException {
        this.m_curSelection = null;
        this.m_SzenarioId = szenarioId;
        this.m_root = this.m_sqlData.Build_LebewesenTree(this.m_root.toString(), this.m_SzenarioId, this.isInSelected);
        this.setRoot(this.m_root);
    }

    private void fireChanges(DefaultMutableTreeNode changed, int what, DefaultMutableTreeNode parent) {
        Object[] path = parent.getPath();
        int[] childIndices = new int[]{parent.getIndex(changed)};
        Object[] children = new Object[]{changed};
        switch (what) {
            case 0: {
                this.fireTreeNodesInserted(changed, path, childIndices, children);
                break;
            }
            case 2: {
                this.fireTreeNodesChanged(changed, path, childIndices, children);
            }
        }
        TreePath tp = new TreePath(changed.getPath());
        this.m_tree.scrollPathToVisible(tp);
        this.m_tree.setSelectionPath(tp);
        this.m_tree.setRequestFocusEnabled(true);
        this.m_tree.setFocusable(true);
    }

    private void fireChanges(DefaultMutableTreeNode changed, int what) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)changed.getParent();
        this.fireChanges(changed, what, parent);
    }

    public void setTree(JTree lebewesenTree) {
        this.m_tree = lebewesenTree;
        this.m_tree.addKeyListener(this);
        this.m_tree.addMouseListener(this);
    }

    public void deleteButtonPressed() {
        this.m_refresher.deleteButtonPressed(this.m_Parent);
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        if (arg0.getKeyCode() == 127) {
            this.deleteButtonPressed();
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        if (arg0.getClickCount() == 2) {
            this.m_refresher.addButtonPressed(this.m_Parent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public void setInNotIn(boolean selected) throws AquaDaoException {
        this.isInSelected = selected;
        this.refresh(this.m_SzenarioId);
    }
}

