/*
 * Decompiled with CFR 0.152.
 */
package model;

import dao.AquaDaoException;
import dao.AquaDaoFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import model.LebewesenNode;
import model.VonBisWerte;

public class Lebewesen {
    private int id;
    private int typ_id;
    private int tempwerte_id;
    private int phwerte_id;
    private String name;
    private String photo;
    private String info;
    private int kantenAb;

    public Lebewesen(ResultSet rs) throws SQLException {
        int columnIndex = 1;
        this.id = rs.getInt(columnIndex++);
        this.name = rs.getString(columnIndex++);
        this.typ_id = rs.getInt(columnIndex++);
        this.tempwerte_id = rs.getInt(columnIndex++);
        this.phwerte_id = rs.getInt(columnIndex++);
        this.info = rs.getString(columnIndex++);
        this.photo = rs.getString(columnIndex++);
        this.kantenAb = rs.getInt(columnIndex++);
    }

    public int columnCount() {
        return 8;
    }

    public Lebewesen(int lid, int ltyp_id, int ltempwerte_id, int lphwerte_id, String lname, String lphoto, String linfo, int lkantenAb) {
        this.id = lid;
        this.typ_id = ltyp_id;
        this.tempwerte_id = ltempwerte_id;
        this.phwerte_id = lphwerte_id;
        this.name = lname;
        this.photo = lphoto;
        this.info = linfo;
        this.kantenAb = lkantenAb;
    }

    public Lebewesen(Lebewesen l) {
        this.id = l.id;
        this.typ_id = l.typ_id;
        this.tempwerte_id = l.tempwerte_id;
        this.phwerte_id = l.phwerte_id;
        this.name = l.name;
        this.photo = l.photo;
        this.info = l.info;
        this.kantenAb = l.kantenAb;
    }

    public String nodeName() {
        return this.name;
    }

    public String toString() {
        return this.nodeName();
    }

    public LebewesenNode BuildNode(boolean isLeaf) {
        LebewesenNode n = new LebewesenNode(this, isLeaf);
        return n;
    }

    public boolean isTyp(Lebewesen l) {
        return this.typ_id == l.typ_id;
    }

    public String nodeType() {
        return "";
    }

    public int getId() {
        return this.id;
    }

    public void updateMenge(int menge) {
    }

    public String getInfo() {
        VonBisWerte v;
        Object data2;
        String ret = "Name: " + this.name + "\n";
        ret = String.valueOf(ret) + "Photo: " + (this.photo != null ? this.photo : "<kein Photo>") + "\n";
        ret = String.valueOf(ret) + "Kantenl\u00e4nge ab: " + this.kantenAb + "\n";
        try {
            data2 = AquaDaoFactory.getInstance().getTempwerteDao();
            v = data2.read(this.tempwerte_id);
            if (v != null) {
                ret = String.valueOf(ret) + v.toString("Temperaturwerte") + "\n";
            }
        }
        catch (AquaDaoException data2) {
            // empty catch block
        }
        try {
            data2 = AquaDaoFactory.getInstance().getPhwerteDao();
            v = data2.read(this.phwerte_id);
            if (v != null) {
                ret = String.valueOf(ret) + v.toString("PH Werte") + "\n";
            }
        }
        catch (AquaDaoException aquaDaoException) {
            // empty catch block
        }
        if (this.info != null) {
            ret = String.valueOf(ret) + this.info + "\n";
        }
        return ret;
    }
}

