/*
 * Decompiled with CFR 0.152.
 */
package dao;

import dao.AquaDaoException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AquaDaoMysql {
    protected static final Logger logger = Logger.getLogger("at.wifiwien.aqua.dao");
    private String url = null;
    private Connection c = null;
    private Statement s = null;
    private PreparedStatement ps = null;
    private CallableStatement cs = null;

    public AquaDaoMysql(String url) {
        this.url = url;
    }

    public void close() throws AquaDaoException {
        try {
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
            if (this.ps != null) {
                this.ps.close();
                this.ps = null;
            }
            if (this.cs != null) {
                this.cs.close();
                this.cs = null;
            }
            if (this.c != null) {
                this.c.close();
                this.c = null;
            }
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQLException: " + e.getMessage(), e);
            throw new AquaDaoException(e.getMessage(), e);
        }
    }

    public Connection getConnection() throws AquaDaoException {
        try {
            this.c = DriverManager.getConnection(this.url);
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQLException: " + e.getMessage(), e);
            throw new AquaDaoException(e.getMessage(), e);
        }
        logger.log(Level.CONFIG, "Connection: " + this.url);
        return this.c;
    }

    public Statement getStatement() throws AquaDaoException {
        if (this.c == null) {
            this.getConnection();
        }
        try {
            this.s = this.c.createStatement();
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQLException: " + e.getMessage(), e);
            throw new AquaDaoException(e.getMessage(), e);
        }
        return this.s;
    }

    public PreparedStatement getPreparedStatement(String sql) throws AquaDaoException {
        if (this.c == null) {
            this.getConnection();
        }
        try {
            this.ps = this.c.prepareStatement(sql);
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQLException: " + e.getMessage(), e);
            throw new AquaDaoException(e.getMessage(), e);
        }
        logger.log(Level.CONFIG, "PreparedStatement: " + sql);
        return this.ps;
    }

    public CallableStatement getCallableStatement(String sql) throws AquaDaoException {
        if (this.c == null) {
            this.getConnection();
        }
        try {
            this.cs = this.c.prepareCall(sql);
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQLException: " + e.getMessage(), e);
            throw new AquaDaoException(e.getMessage(), e);
        }
        logger.log(Level.CONFIG, "CallableStatement: " + sql);
        return this.cs;
    }

    protected void test() throws AquaDaoException {
        try {
            try {
                ResultSet rs = this.getCallableStatement("{call hello}").executeQuery();
                rs.next();
                System.out.println(rs.getString(1));
                rs.close();
                this.getStatement().execute("DROP TABLE Greetings");
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, "SQLException: " + e.getMessage(), e);
                throw new AquaDaoException(e.getMessage(), e);
            }
        }
        finally {
            this.close();
        }
    }
}

