/*
 * Decompiled with CFR 0.152.
 */
package dao;

import dao.AquaDaoException;
import dao.AquaDaoFactoryMysql;
import dao.AquaDaoMysql;
import dao.DimensionenDao;
import dao.LebewesenDao;
import dao.PhwerteDao;
import dao.StatistikDao;
import dao.SzenarienDao;
import dao.SzenarioFutterzeitDao;
import dao.TempwerteDao;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AquaDaoFactory {
    private static final Logger logger = Logger.getLogger("at.wifiwien.aqua.dao");
    private static final String PROPERTIES_FILE = "aquadb.properties";
    private static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    private static AquaDaoFactory instance = null;

    public static AquaDaoFactory getInstance() throws AquaDaoException {
        if (instance == null) {
            Properties p = AquaDaoFactory.loadProperties();
            if (p.getProperty("db.typ").toLowerCase().equals("mysql")) {
                AquaDaoFactory.loadDriver(MYSQL_DRIVER);
                instance = new AquaDaoFactoryMysql(p);
            } else {
                logger.log(Level.SEVERE, "Unknown Datebase Type");
                throw new AquaDaoException("Unknown Datebase Type");
            }
        }
        return instance;
    }

    public abstract StatistikDao getStatistikDao();

    public abstract SzenarienDao getSzenarienDao();

    public abstract SzenarioFutterzeitDao getSzenarioFutterzeitDao();

    public abstract DimensionenDao getDimensionenDao();

    public abstract LebewesenDao getLebewesenDao();

    public abstract PhwerteDao getPhwerteDao();

    public abstract TempwerteDao getTempwerteDao();

    protected abstract AquaDaoMysql getAquaDao();

    private static void loadDriver(String driver) throws AquaDaoException {
        try {
            Class.forName(driver).newInstance();
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, "InstantiationException: " + e.getMessage(), e);
            throw new AquaDaoException("InstantiationException: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "IllegalAccessException: " + e.getMessage(), e);
            throw new AquaDaoException("IllegalAccessException: " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "ClassNotFoundException: " + e.getMessage(), e);
            throw new AquaDaoException("ClassNotFoundException: " + e.getMessage(), e);
        }
    }

    private static Properties loadProperties() throws AquaDaoException {
        Properties properties = new Properties();
        try {
            InputStream is = AquaDaoFactory.class.getResourceAsStream(PROPERTIES_FILE);
            properties.load(is);
            is.close();
            return properties;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IOException: " + e.getMessage(), e);
            throw new AquaDaoException("IOException: " + e.getMessage(), e);
        }
    }
}

