/*
 * Decompiled with CFR 0.152.
 */
package view;

import dao.AquaDaoException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import main.ErrorMessage;
import main.Resources;
import model.Lebewesen;
import model.LebewesenModel;
import view.ILebewesenRefresher;

public class PanelSzenarioTrees
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 871598368878726765L;
    private Dimension filterPanePreferredSize = new Dimension(130, 30);
    private Dimension treePanePreferredSize = new Dimension(130, 140);
    private Dimension infoPanePreferredSize = new Dimension(130, 140);
    private JPanel filterPanel = new JPanel();
    private JTree lebewesenTree = new JTree();
    private JTextPane infoPane = new JTextPane();
    private LebewesenModel m_lebewesenModel;

    public PanelSzenarioTrees(String keyInfoText, boolean useCheckbox) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.add((Component)this.getFilterPanel(), "North");
        this.add((Component)this.getTreePane(), "Center");
        this.add((Component)this.getInfoPane(), "South");
        this.setInfo(Resources.getString(keyInfoText));
        if (useCheckbox) {
            this.addCheckBox();
        }
    }

    private JPanel getFilterPanel() {
        BoxLayout layout = new BoxLayout(this.filterPanel, 0);
        this.filterPanel.setLayout(layout);
        this.filterPanel.setPreferredSize(this.filterPanePreferredSize);
        return this.filterPanel;
    }

    private JScrollPane getTreePane() {
        this.lebewesenTree.setEditable(false);
        this.lebewesenTree.getSelectionModel().setSelectionMode(1);
        JScrollPane treeScrollPane = new JScrollPane(this.lebewesenTree);
        treeScrollPane.setPreferredSize(this.treePanePreferredSize);
        return treeScrollPane;
    }

    private JScrollPane getInfoPane() {
        this.infoPane.setEditable(false);
        JScrollPane panel = new JScrollPane(this.infoPane);
        panel.setPreferredSize(this.infoPanePreferredSize);
        return panel;
    }

    private void addCheckBox() {
        JCheckBox cBox = new JCheckBox(Resources.getString("Szen.lwp_filter"));
        cBox.setActionCommand("cbnotinaqua");
        cBox.addActionListener(this);
        this.filterPanel.add(cBox);
    }

    public void setInfo(String info) {
        this.infoPane.setText(info);
    }

    public void setModel(String keyTreeRoot, int szenarioId) throws AquaDaoException {
        this.m_lebewesenModel = new LebewesenModel(Resources.getString(keyTreeRoot), szenarioId);
        this.m_lebewesenModel.setTree(this.lebewesenTree);
        this.lebewesenTree.setModel(this.m_lebewesenModel);
        this.lebewesenTree.addTreeSelectionListener(this.m_lebewesenModel);
    }

    public void setRefresher(ILebewesenRefresher r) {
        this.m_lebewesenModel.setRefresher(r, this);
    }

    public Lebewesen selectedLebewesen() {
        return this.m_lebewesenModel.currentSelection().toLebewesen();
    }

    public void add(Lebewesen selectedLebewesen) throws AquaDaoException {
        this.m_lebewesenModel.add(selectedLebewesen);
    }

    public void removeSelectedLebewesen() throws AquaDaoException {
        this.m_lebewesenModel.removeSelectedLebewesen();
    }

    public void refresh(int szenarioId) throws AquaDaoException {
        this.m_lebewesenModel.refresh(szenarioId);
    }

    public void updateTree() {
        this.lebewesenTree.setVisible(false);
        this.lebewesenTree.setVisible(true);
    }

    public void refreshInfo(Lebewesen curSel) {
        if (curSel != null) {
            this.setInfo(curSel.getInfo());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        try {
            if (cmd.equals("cbnotinaqua")) {
                this.m_lebewesenModel.setInNotIn(((JCheckBox)e.getSource()).getModel().isSelected());
            }
        }
        catch (AquaDaoException ade) {
            ErrorMessage.show(1);
        }
    }
}

