/*
 * Decompiled with CFR 0.152.
 */
package model;

import dao.AquaDaoException;
import dao.AquaDaoFactory;
import dao.SzenarioFutterzeitDao;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class SzenarioFutterzeit
extends AbstractListModel {
    private static final long serialVersionUID = -4823111994559081489L;
    public static final String FORMATPATTERN = "HH:mm";
    public static final SimpleDateFormat TIMEFORMAT = new SimpleDateFormat("HH:mm");
    public static final long PAUSE = 1800000L;
    public static final String DEFAULTZEIT = "04:00";
    private static SzenarioFutterzeitDao dao = null;
    private Vector<String> times = null;

    public SzenarioFutterzeit(int szen_id) throws AquaDaoException {
        dao = AquaDaoFactory.getInstance().getSzenarioFutterzeitDao();
        if (szen_id != 0) {
            this.times = dao.read(szen_id);
        } else {
            this.times = new Vector();
            this.times.add(DEFAULTZEIT);
        }
    }

    @Override
    public Object getElementAt(int index) {
        return this.times.get(index);
    }

    @Override
    public int getSize() {
        return this.times.size();
    }

    public void add(Object value) {
        String time;
        if (value instanceof Date && this.checkTime(time = TIMEFORMAT.format((Date)value))) {
            this.times.add(time);
            this.fireIntervalAdded(this, this.times.size() - 1, this.times.size() - 1);
        }
    }

    public void remove(int index) {
        this.times.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void save(int szen_id) throws AquaDaoException {
        dao.create(szen_id, this.times);
    }

    public void delete(int szen_id) throws AquaDaoException {
        dao.delete(szen_id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkTime(String time) {
        try {
            long oldTime;
            Date oldDate;
            long newTime = TIMEFORMAT.parse(time).getTime();
            Date newDate = new Date(newTime);
            Iterator<String> iterator = this.times.iterator();
            do {
                if (!iterator.hasNext()) {
                    return true;
                }
                String s = iterator.next();
                oldTime = TIMEFORMAT.parse(s).getTime();
                oldDate = new Date(oldTime);
                if (newDate.compareTo(oldDate) < 0) continue;
                if (newTime - oldTime < 1800000L) return false;
            } while (newDate.compareTo(oldDate) > 0 || oldTime - newTime >= 1800000L);
            return false;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }
}

