/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import main.AquaPreferences;
import main.Resources;
import view.MenuBarAqua;
import view.PanelSzenario;

public class AquaEditorApplication
extends JFrame
implements WindowStateListener {
    private static final long serialVersionUID = 3584800399190190155L;
    private AquaPreferences prefs = new AquaPreferences(this);

    public static void main(String[] args) {
        new AquaEditorApplication();
    }

    public AquaEditorApplication() {
        Resources.setResourceBundle(this.prefs.getLocale());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AquaEditorApplication.this.init();
            }
        });
    }

    private void init() {
        this.setTitle(Resources.getString("Frame.title"));
        this.setLookAndFeel(this.prefs.getLafClassName());
        this.setContent();
        this.setBoundsAndState();
        this.setVisible(true);
        this.addWindowStateListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AquaEditorApplication.this.saveAndExit();
            }
        });
    }

    private void setLookAndFeel(String lafClassName) {
        try {
            UIManager.setLookAndFeel(lafClassName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void setContent() {
        this.setJMenuBar(new MenuBarAqua(this));
        this.getContentPane().add((Component)new PanelSzenario(), "Center");
    }

    private void setBoundsAndState() {
        this.setSize(this.prefs.getWindowSize());
        this.setLocation(this.prefs.getWindowPoint());
        this.setExtendedState(this.prefs.getWindowState());
    }

    private void saveBounds() {
        if (this.getExtendedState() == 0) {
            this.prefs.setWindowPoint(this.getLocation());
            this.prefs.setWindowSize(this.getSize());
        }
    }

    private void saveLookAndFeel() {
        this.prefs.setLafClassName(UIManager.getLookAndFeel().getClass().getName());
    }

    public void saveAndExit() {
        this.saveBounds();
        this.saveLookAndFeel();
        System.exit(0);
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        this.prefs.setWindowState(this.getExtendedState());
    }
}

