/*
 * Decompiled with CFR 0.152.
 */
package dao;

import dao.AquaDaoException;
import dao.AquaDaoMysql;
import dao.SzenarienDao;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import model.Szenario;

public class SzenarienDaoMysql
extends AquaDaoMysql
implements SzenarienDao {
    public static final String ID = "ID";
    public static final String NAME = "Name";
    public static final String SHORTNAME = "ShortName";
    public static final String TEMPMIN = "TempMin";
    public static final String TEMPMAX = "TempMax";
    public static final String PHMIN = "PHMin";
    public static final String PHMAX = "PHMax";
    public static final String LICHTEIN = "LichtEin";
    public static final String LICHTAUS = "LichtAus";
    public static final String DIM_ID = "Dim_ID";
    public static final String INSERT = "INSERT INTO szenarien (Name, ShortName, TempMin, TempMax, PHMin, PHMax, LichtEin, LichtAus, Dim_ID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String SELECT_ALL = "SELECT s.ID, s.Name, s.ShortName, s.TempMin, s.TempMax, s.PHMin, s.PHMax, s.LichtEin, s.LichtAus, s.Dim_ID FROM szenarien s ORDER BY 1 DESC";
    public static final String SELECT_BY_ID = "SELECT s.ID, s.Name, s.ShortName, s.TempMin, s.TempMax, s.PHMin, s.PHMax, s.LichtEin, s.LichtAus, s.Dim_ID FROM szenarien s WHERE ID = ?";
    public static final String UPDATE = "UPDATE szenarien SET Name = ?, ShortName = ?, TempMin = ?, TempMax = ?, PHMin = ?, PHMax = ?, LichtEin = ?, LichtAus = ?, Dim_ID = ?  WHERE szenarien.ID = ?";
    public static final String DELETE_BY_ID = "DELETE FROM szenarien WHERE szenarien.ID = ?";

    public SzenarienDaoMysql(String url) {
        super(url);
    }

    @Override
    public int create(String name, String shortname, double tempMin, double tempMax, double phMin, double phMax, Date lichtEin, Date lichtAus, int dim_ID) throws AquaDaoException {
        try {
            PreparedStatement ps = this.getPreparedStatement(INSERT);
            ps.setString(1, name);
            ps.setString(2, shortname);
            ps.setDouble(3, tempMin);
            ps.setDouble(4, tempMax);
            ps.setDouble(5, phMin);
            ps.setDouble(6, phMax);
            ps.setString(7, this.getString(lichtEin));
            ps.setString(8, this.getString(lichtAus));
            ps.setInt(9, dim_ID);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQLException: " + e.getMessage(), e);
            throw new AquaDaoException(e.getMessage(), e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public Vector<Szenario> read() throws AquaDaoException {
        try {
            ResultSet rs = this.getStatement().executeQuery(SELECT_ALL);
            Vector<Szenario> vector = this.createSzenarien(rs);
            return vector;
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQLException: " + e.getMessage(), e);
            throw new AquaDaoException(e.getMessage(), e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void update(int id, String name, String shortname, double tempMin, double tempMax, double phMin, double phMax, Date lichtEin, Date lichtAus, int dim_ID) throws AquaDaoException {
        try {
            try {
                PreparedStatement ps = this.getPreparedStatement(UPDATE);
                ps.setString(1, name);
                ps.setString(2, shortname);
                ps.setDouble(3, tempMin);
                ps.setDouble(4, tempMax);
                ps.setDouble(5, phMin);
                ps.setDouble(6, phMax);
                ps.setString(7, this.getString(lichtEin));
                ps.setString(8, this.getString(lichtAus));
                ps.setInt(9, dim_ID);
                ps.setInt(10, id);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, "SQLException: " + e.getMessage(), e);
                throw new AquaDaoException(e.getMessage(), e);
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void delete(int id) throws AquaDaoException {
        try {
            try {
                PreparedStatement ps = this.getPreparedStatement(DELETE_BY_ID);
                ps.setInt(1, id);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, "SQLException: " + e.getMessage(), e);
                throw new AquaDaoException(e.getMessage(), e);
            }
        }
        finally {
            this.close();
        }
    }

    private Vector<Szenario> createSzenarien(ResultSet rs) throws SQLException, AquaDaoException {
        Vector<Szenario> v = new Vector<Szenario>();
        while (rs.next()) {
            v.add(new Szenario(rs.getInt(ID), rs.getString(NAME), rs.getString(SHORTNAME), rs.getDouble(TEMPMIN), rs.getDouble(TEMPMAX), rs.getDouble(PHMIN), rs.getDouble(PHMAX), this.getDate(rs.getString(LICHTEIN)), this.getDate(rs.getString(LICHTAUS)), rs.getInt(DIM_ID)));
        }
        rs.close();
        return v;
    }

    private Date getDate(String text) throws AquaDaoException {
        Date date;
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        try {
            date = sdf.parse(text);
        }
        catch (ParseException e) {
            logger.log(Level.SEVERE, "ParseException: " + e.getMessage(), e);
            throw new AquaDaoException(e.getMessage(), e);
        }
        return date;
    }

    private String getString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        return sdf.format(date);
    }
}

