/*
 * Decompiled with CFR 0.152.
 */
package dao;

import dao.AquaDaoException;
import dao.AquaDaoMysql;
import dao.DimensionenDao;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import model.Dimensionen;

public class DimensionenDaoMysql
extends AquaDaoMysql
implements DimensionenDao {
    public static final String ID = "ID";
    public static final String L = "L";
    public static final String B = "B";
    public static final String H = "H";
    public static final String Volumen = "Volumen";
    public static final String INSERT = "INSERT INTO dimensionen (L, B, H, Volumen) VALUES (?, ?, ?, ?)";
    public static final String SELECT_ALL = "SELECT ID, L, B, H, Volumen FROM dimensionen ORDER BY 1 DESC";
    public static final String SELECT_BY_ID = "SELECT ID, L, B, H, Volumen FROM dimensionen WHERE ID = ?";
    public static final String UPDATE = "UPDATE dimensionen SET L = ?, B = ?, H = ?, Volumen = ? WHERE dimensionen.ID = ?";
    public static final String DELETE_BY_ID = "DELETE FROM dimensionen WHERE dimensionen.ID = ?";

    public DimensionenDaoMysql(String url) {
        super(url);
    }

    @Override
    public int create(int[] values) throws AquaDaoException {
        try {
            PreparedStatement ps = this.getPreparedStatement(INSERT);
            int i = 0;
            while (i < values.length) {
                ps.setInt(i + 1, values[i]);
                ++i;
            }
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQLException: " + e.getMessage(), e);
            throw new AquaDaoException(e.getMessage(), e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public Vector<Dimensionen> read() throws AquaDaoException {
        try {
            ResultSet rs = this.getStatement().executeQuery(SELECT_ALL);
            Vector<Dimensionen> vector = this.createDimensionenList(rs);
            return vector;
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQLException: " + e.getMessage(), e);
            throw new AquaDaoException(e.getMessage(), e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void update(int id, int[] values) throws AquaDaoException {
        try {
            try {
                PreparedStatement ps = this.getPreparedStatement(UPDATE);
                int i = 0;
                while (i < values.length) {
                    ps.setInt(i + 1, values[i]);
                    ++i;
                }
                ps.setInt(5, id);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, "SQLException: " + e.getMessage(), e);
                throw new AquaDaoException(e.getMessage(), e);
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void delete(int id) throws AquaDaoException {
        try {
            try {
                PreparedStatement ps = this.getPreparedStatement(DELETE_BY_ID);
                ps.setInt(1, id);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, "SQLException: " + e.getMessage(), e);
                throw new AquaDaoException(e.getMessage(), e);
            }
        }
        finally {
            this.close();
        }
    }

    private Vector<Dimensionen> createDimensionenList(ResultSet rs) throws SQLException {
        Vector<Dimensionen> v = new Vector<Dimensionen>();
        while (rs.next()) {
            v.add(new Dimensionen(rs.getInt(ID), new int[]{rs.getInt(L), rs.getInt(B), rs.getInt(H), rs.getInt(Volumen)}));
        }
        rs.close();
        return v;
    }
}

